#!/usr/bin/env bash
# bin/erd_for_cpp.sh

# save current working directory
here=`pwd`

my_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
source $my_dir/check_app_root

doc_dir=$APP_ROOT/doc

cd $APP_ROOT

bundle exec erd --title="High-level CPP Data Model" \
  --orientation=vertical \
  --cluster \
  --prepend_primary=true \
  --sort=true \
  --direct \
  --only="User,Visn,Facility,Provider,ProvidersUser,Veteran,Referral,Consultation" \
  --filename=$doc_dir/cpp_high_level_erd --filetype=pdf

cd $here

#  --only_recursion_depth=1 \
