# == Schema Information
#
# Table name: consultations
#
#  id                     :integer          not null, primary key
#  consultation_number    :string           not null
#  ordering_provider_id   :integer
#  valid_from             :datetime
#  valid_to               :datetime
#  content                :json
#  created_at             :datetime         not null
#  updated_at             :datetime         not null
#  care_category_id       :integer
#  consultation_order_id  :integer
#  consultation_status_id :integer
#  consultation_type_id   :integer
#  veteran_id             :integer
#

# The Consultation model is currently backed by a database record.
# However in the objective system it will be some kind of
# ActiveModel backed by a web-service.

module VIA_API
  module Models

    class Consultation < ::EnhancedHash
      property :id
      property :timestamp
      property :status
      property :text
      property :title
    end

  end
end
