# app/services/mvi/retrieve_person.rb
module MVI

  class << self

    ##############################################################
    def retrieve_person edipi, request_id
      request = MVI_CLIENT.build_request(:prpa_in201305_uv02, attributes: MVI::MSG_TAG_ATTRIBUTES, message: retrieve_person_request(edipi, request_id))
      request_xml = add_default_header(request.body)
      req_xml = remove_namespaces(request_xml)
      begin
        response  = MVI_CLIENT.call(:prpa_in201305_uv02, xml: req_xml)
      rescue Savon::SOAPFault => e 
        raise MviApiFaultError.new("System is unavailable. Request cannot be completed at this time.")
      end

      data = response.body

      fault_message = data.dig(:fault, :faultstring)
      if fault_message.present?
          raise MviApiFaultError.new(fault_message)
      end

      ack_code = data.dig(:prpa_in201306_uv02, :acknowledgement, :type_code, :@code)
      query_code = data.dig(:prpa_in201306_uv02, :control_act_process, :query_ack, :query_response_code, :@code)

      if ack_code == "AE" && query_code == "AE"
        raise MviPersonNotFoundError.new("Veteran not found.")
      elsif ack_code == "AR"
        ack_detail = data.dig(:prpa_in201306_uv02,:acknowledgement, :acknowledgement_detail)
        ack_detail = array_of_hashes ack_detail
        msg = ack_detail.find { |elem| elem.has_key?(:text) }
        regex = /MVI\[S\]\:INVALID\s+REQUEST/i
        if regex.match(msg[:text])
          raise MviApplicationReject.new("Database is down. Request cannot be completed at this time. Please try again later.")
        else
          raise MviApplicationReject.new("#{msg[:text]}")
        end
      end

      if ack_code == "AA"
        person_data = data.dig(:prpa_in201306_uv02, :control_act_process, :subject, :registration_event, :subject1)
      end

      return person_data
    end

    def retrieve_person_request(edipi, unique_request_id)
      edipi_parameter = edipi + "^NI^200DOD^USDOD"

      request = {
        :id => { :@root => "1.2.840.114350.1.13.0.1.7.1.1", :@extension => unique_request_id },
        :creationTime => { :@value => MVI.encode_mvi_date(Time.now) },
        :versionCode => { :@code => "3.5" },
        :interactionId => { :@root => "2.16.840.1.113883.1.6", :@extension => "PRPA_IN201305UV02" },
        :processingCode => { :@code => "T" },
        :processingModeCode => { :@code => "T" },
        :acceptAckCode => { :@code => "AL" },
        :receiver => { 
          :@typeCode => "RCV",
          :device => {
            :@classCode => "DEV", 
            :@determinerCode => "INSTANCE",
            :id => {
              :@root => "1.2.840.114350.1.13.999.234"
            },
            :telecom => {
              :@value => "http://servicelocation/PDQuery"
            }
          }
        },
        :sender => {
          :@typeCode => "SND",
          :device => {
            :@classCode => "DEV",
            :@determinerCode => "INSTANCE",
            :id => {
              :@extension => MVI::APP_NAME,
              :@root => "2.16.840.1.113883.4.349"
            }
          }
        },
        :controlActProcess => {
          :@classCode => "CACT",
          :@moodCode => "EVN",
          :dataEnterer => {
            :@typeCode => "ENT",
            :@contextControlCode => "AP",
            :assignedPerson => {
              :@classCode => "ASSIGNED",
              :id => {
                :@extension => MVI::APP_NAME,
                :@root => "2.16.840.1.113883.777.999"
              },
              :assignedPerson => {
                :@classCode => "PSN",
                :@determinerCode => "INSTANCE",
                :name => {
                  :given => "CUI Interface",
                  :family => "Submitter"
                }
              }
            }
          },
          :code => {
            :@code => "PRPA_TE201305UV02",
            :@codeSystem => "2.16.840.1.113883.1.6"
          },
          :queryByParameter => {
            :queryId => {
              :@root => "1.2.840.114350.1.13.28.1.18.5.999",
              :@extension => unique_request_id
            },
            :statusCode => {
              :@code => "new"
            },
            :modifyCode => {
              :@code => "MVI.COMP1"
            },
            :initialQuantity => {
              :@value => "1"
            },
            :parameterList => {
              :id => {
                :@extension => edipi_parameter,
                :@root => "2.16.840.1.113883.4.349"
              }
            }
          }
        }
      }
      request
    end  

    private
      def array_of_hashes val
        if val.is_a? Hash
          [ val ]
        elsif val.is_a? Array
          val
        elsif val.nil?
          []
        end
      end

  end
end
