module MVI

  class ProcessRetrievePersonResponse

    # Takes in veteran data from MVI retrieve person call
    # Main output is the veteran_hash that is provided to the MVI proxy add to vista call.
    def initialize vet_data, user_name, site
      @vet_data = vet_data
      @user_name = user_name
      @site = site
      @veteran_hash = {}
    end

    def get_veteran_sites_list
      site_registration_list = @vet_data.dig(:patient, :id).select { |site| site[:@extension] =~ /PI\S+USVHA/ }.map {|i| i[:@extension] }
      @reg_list = []
      site_registration_list.each do |site_str|
        site_array = site_str.split("^")
        site_array[2] = site_array[2] + "/" + Site.find_by_site_station_number(site_array[2]).try(:name).to_s
        @reg_list.push(site_array)
      end
      @reg_list
    end

    def is_veteran_registered?
      @reg_list ||= get_veteran_sites_list
      vista_site = @site.site_station_number
      @reg_list.map {|site| site[2] }.include?(vista_site)
    end

    def create_veteran_hash request_id, station_number
      get_name

      numeric_from_requestid = /MCI-CUI-(\w+)/.match(request_id).try(:[],1).to_s
      new_request_id = "MCI-CUIA-" + numeric_from_requestid
      @veteran_hash[:retrieve_person_request_id] = new_request_id
      @veteran_hash[:station_number] = station_number

      get_icn
      get_vet_address
      
      # patient's phone not provided in 1306 sample responses
      @veteran_hash[:telecom_value] = ""
      @veteran_hash[:telecom_usage] = ""
      
      get_gender
      get_birthdate
      get_ssn
      get_clinic_name
      get_data_enterer
      
      @veteran_hash
    end

    def patient_full_name
      get_name
      "#{@veteran_hash[:fname]} #{@veteran_hash[:mname]} #{@veteran_hash[:lname]}"
    end

    private

    def get_name
      name = @vet_data.dig(:patient, :patient_person, :name)
      name = array_of_hashes(name)
      name_hash = name.find { |elem| elem.has_key?(:given) }

      # set veteran_hash with first, last, middle names
      if name_hash[:given].is_a?(Array) 
        @veteran_hash[:fname] =  name_hash[:given][0]
        @veteran_hash[:mname] =  name_hash[:given][1]
      else
        @veteran_hash[:fname] =  name_hash[:given]
      end
        @veteran_hash[:lname] = name_hash[:family]
    end

    def get_icn
      icn_str = @vet_data.dig(:patient, :id).select { |site| site[:@extension] =~ /NI\S+USVHA/ }.map {|i| i[:@extension] }.first
      icn = /(\w+)\^NI/.match(icn_str)[1]
      @veteran_hash[:patient_icn] = icn
    end

    def get_vet_address
      addr = @vet_data.dig(:patient, :patient_person, :addr)
      if !addr.nil?
        @veteran_hash[:addr_usage] = addr.delete(:@use)
        @veteran_hash[:addr] = addr
      else
        @veteran_hash[:addr_usage] = ""
        @veteran_hash[:addr] = ""
      end
    end

    def get_gender
      @veteran_hash[:gender] = @vet_data.dig(:patient, :patient_person, :administrative_gender_code, :@code)
    end

    def get_birthdate
      @veteran_hash[:birth_date] = @vet_data.dig(:patient, :patient_person, :birth_time, :@value)
    end

    def get_veteran_ssn as_other_ids
      if as_other_ids.is_a? Array
        ssn_id_hash = as_other_ids.select {|ids| ids[:@class_code] == "SSN"}.first
        ssn = ssn_id_hash.dig(:id, :@extension)
      elsif as_other_ids.is_a? Hash
        ssn = ( as_other_ids.dig(:@class_code) == "SSN" ? as_other_ids.dig(:id, :@extension) : "" )
      end

      ssn
    end

    def get_ssn
      @veteran_hash[:ssn] = get_veteran_ssn(@vet_data.dig(:patient, :patient_person, :as_other_i_ds))
    end

    # FIXME
    # currently don't have clinic names
    # subsituting Vista site name
    def get_clinic_name
      @veteran_hash[:clinic_name] = @site.name
    end

    def get_data_enterer
      @veteran_hash[:data_enterer_name] = @user_name
    end

    def array_of_hashes val
      if val.is_a? Hash
        [ val ]
      elsif val.is_a? Array
        val
      elsif val.nil?
        []
      end
    end

  # end of Process Retrieve Person Response
  end

# end of MVI
end