require_rel 'mvi/**/*.rb'

module MVI

  MVI_DATE_FORMAT = "%Y%m%d%H%M%S"
  APP_NAME        = "200CUIE"
  MSG_TAG_ATTRIBUTES      = {
    'xmlns' => 'urn:hl7-org:v3',
    'xmlns:ps' => 'http://URL',
    'xmlns:partns' => 'http://URL',
    'xmlns:xsi' => 'http://www.w3.org/2001/XMLSchema-instance',
    'xsi:schemaLocation' => 'urn:hl7-org:v3 ../../schema/HL7V3/NE2008/multicacheschemas/PRPA_IN201305UV02.xsd',
    'ITSVersion' => 'XML_1.0'
  }
  
  MVI_ENDPOINT_URL = ENV['MVI_API_URL'] + "IdMWebService"

  MVI_CLIENT = Savon.client do
    wsdl(Rails.root.join("app", "services", "mvi", "IdmWebService_wsdl_1305_1301_xsd_file.txt").to_s)
    endpoint(MVI_ENDPOINT_URL)
    element_form_default(:unqualified)
    log(true)
    logger(Rails.logger)
    pretty_print_xml(true)
    ssl_cert_file(Rails.root.join("ssl","dev","www.dev-cui.va.gov.crt").to_s)
    ssl_cert_key_file(Rails.root.join("ssl","dev","www.dev-cui.va.gov.key").to_s)
  end

  # basic response error for unexpected errors
  class MviApiError < RuntimeError; end

  # response contains fault tag 
  class MviApiFaultError < MviApiError; end

  # Person Not Found errors
  class MviPersonNotFoundError < MviApiError; end

  # MVI service returns an application error
  class MviApplicationError < MviApiError; end

  # MVI service system downtime
  class MviApplicationReject < MviApiError; end

  class << self
    
    def encode_mvi_date(date)
      date.strftime(MVI_DATE_FORMAT)
    end

    # MVI requires a soap header even if its empty
    def add_default_header xml
      doc = Nokogiri::XML(xml)
      doc.at_xpath('//env:Envelope').children.first.add_previous_sibling(Nokogiri::XML::Node.new("Header", doc))
      doc.to_xml
    end

    def remove_namespaces request_xml
      regex = %r{
        \s+
        (xmlns:xsd=\"http:\/\/www.w3.org\/2001\/XMLSchema\")
        \s+
        (xmlns:xsi=\"http:\/\/www.w3.org\/2001\/XMLSchema-instance\")
        \s+
        (xmlns:partns=\"http:URL\")
      }x
      request_xml.sub(regex, "")
    end
  end

end