# files in this folder were not being read?
require_rel '../**/*.rb'

module DAS
  module DRS
    class FHIR
      class << self

        # Application facing methods
        def store(location, file)
          store_document(location, file)
        end

        # web-service methods
        private

        def store_document(location, file)
          case location
          when 'DAS'
            store_on_das file
          when 'real_docstore' || 'fake_docstore'
            store_on_docstore(location, file)
          else
            raise Exception, "Invalid storage location for DAS."
          end
        end

        def store_on_das(file)
          # we need to store a ReferralDocument so it can be retrieved by DAS
            # needs to have a URN - unique document identifier
              # this is referral_document.referral_document_id?
            # need to add a route for the GET
            # later need to change the UPDATE to use DAS

          # We send a POST to DAS
            # includes the document URN
            # includes a transaction ID - unique identfier for the request
              # is this a model or an envirnment variable?
            #  and other content
          # They send a GET to obtain the document
            # Need to add a GET route to RefferalDocument
          # They send a POST giving us the URL where it is stored in DAS
            # Rails wants a PATCH to update a record, they are using a POST which Rails uses for create
              # customize route and controller to accommodate this
            # Add a column for das_url to RefferalDocument
            # we store this das_url in model
          # we delete the doc from our app?

          raise Exception, "Actual storage on DAS is not yet implemented."
        end

        def store_on_docstore(location, file)
          upload_path = File.join(Rails.root, "public/#{location}")
          file_name = file.original_filename
          tmpfile = file.tempfile
          tmpfile.close #Unix might let you move an open file, but not windows.
          FileUtils.mv tmpfile, File.join(upload_path, file_name)
        end

      end # class << self
    end # class FHIR
  end # module DRS
end # module DAS
