class NeurologicalOtherEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: "Neurological Other", base_document: 'neurological_other.xml'

  def modify_document
    evaluation_root.at_xpath("//nof:value").content = evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'nof', basename: 'neurologicalOther')

    add_parent_evaluations(evaluation, "//nof:neurologicalOtherFacts")
  end
end
