class MusculoskeletalSystemAmputationEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal System - Amputations', base_document: 'amputation.xml'

  SYMPTOM_TYPES = {
    leftLowerExtremity:   'leftLowerExtremitySymptoms',
    rightLowerExtremity:  'rightLowerExtremitySymptoms',
    minorUpperExtremity:  'minorExtremitySymptoms',
    majorUpperExtremity:  'majorExtremitySymptoms'
  }

  def modify_document
    evaluation_root.xpath("ampf:amputationFacts/ampf:amputationDiagnoses/ampf:value").first.content = evaluation.evaluation_spec.title

    fields = FML::Form.from_json(evaluation.doc.to_json).fields
    SYMPTOM_TYPES.each { |matching_name, xml_path|
      add_presentable_symptoms(namespace: 'ampf', basename: 'amputation', after: 'amputationDiagnoses',
                                symptoms_element: xml_path, presentation_subset: Regexp.new(matching_name.to_s))
    }

    setfield('//ampf:lossOfUseOfMajorExtremity', to: fields['majorUpperExtremityLoss'].value)
    setfield('//ampf:lossOfUseOfMinorExtremity', to: fields['minorUpperExtremityLoss'].value)
    setfield('//ampf:lossOfUseOfRightLowerExtremity', to: fields['rightLowerExtremityLoss'].value)
    setfield('//ampf:lossOfUseOfLeftLowerExtremity', to: fields['leftLowerExtremityLoss'].value)

    add_parent_evaluations(evaluation, "//ampf:amputationFacts")
  end
end
