class MentalDisorderEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Mental Disorders', base_document: 'mental-disorder.xml'

  def modify_document
    form = FML::Form.from_json(evaluation.doc.to_json)
    evaluation_root.xpath("mdf:mentalDisorderFacts/mdf:mentalDisorderDiagnoses/mdf:value").first.content = rating_calculator_options_match(form.fields['mentalDiagnosis'])
    add_presentable_symptoms(namespace: 'mdf', basename: 'mentalDisorder', excluded_fields: ['mentalDiagnosis'] )
    add_fact_node("mdf:dsmType", "DSM-V", "mdf:mentalDisorderFacts")

    add_parent_evaluations(evaluation, "//mdf:mentalDisorderFacts")
  end
end
