class CardiovascularEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Cardiovascular', base_document: 'cardiovascular.xml'

  FACT_FIELD_NAMES = ["ankle", "brachial", "ABI"]
  FACT_VALUE_NAMES = ["cardioVascularLVEFsReading", "cardioVascularMETsReading"]

  def modify_document
    form = FML::Form.from_json(evaluation.doc.to_json)

    if form.fields.has_key?("selectExtremity") && !form.fields["selectExtremity"].value.nil?
      bilateral_node = Nokogiri::XML::Node.new("bsf:bilateralType", document)
      bilateral_node.content = form.fields["selectExtremity"].value
      evaluation_root.xpath("cf:cardiovascularFacts").first.prepend_child bilateral_node
    end

    evaluation_root.xpath("cf:cardiovascularFacts/cf:cardiovascularDiagnoses/cf:value").first.content = evaluation.evaluation_spec.title

    add_presentable_symptoms(namespace: 'cf', basename: 'cardiovascular', excluded_fields:["selectExtremity"])
    FACT_FIELD_NAMES.each do |fact_field_name|
      if form.fields[fact_field_name] && form.fields[fact_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("cf:#{fact_field_name}", document)
        fact_node.content = form.fields[fact_field_name].value
        evaluation_root.xpath("cf:cardiovascularFacts").first << fact_node
      end
    end

    FACT_VALUE_NAMES.each do |fact_field_name|
      if form.fields[fact_field_name] && form.fields[fact_field_name].to_h.has_key?(:value)
        node = make_symptoms_node("cf", fact_field_name, form.fields[fact_field_name].value, self.document)
        evaluation_root.xpath("cf:cardiovascularFacts").first << node
      end
    end

    # the "contraindication" field must say "yes" or "no"
    if form.fields.has_key?("contraindication") && !form.fields["contraindication"].value.nil?
      fact_node = Nokogiri::XML::Node.new("cf:contraindication", document)
      fact_node.content = form.fields["contraindication"].value ? "Yes" : "No"
      evaluation_root.xpath("cf:cardiovascularFacts").first << fact_node
    end

    # The "Small Artery" exam needs to say "asymptomatic" if "symptomaticAneurysm" is false
    #
    # XXX: is this a bug if there are more than one cardiovascularFacts in the document? If
    #      so it is a widespread bug that needs real thought. (becuase we may not be adding
    #      stuff to the *first* cardiovascularFacts node; each presenter ought to be
    #      operating only on its own Facts, not a global element)
    if form.id == "083d8f5de38098b0a741b285ea72f72419aa0f65" && form.fields["symptomaticAneurysm"].value == false
      evaluation_root.xpath("cf:cardiovascularFacts").first <<
        make_symptoms_node("cf", "cardiovascularSymptoms", "Asymptomatic", self.document)
    end

    add_parent_evaluations(evaluation, "//cf:cardiovascularFacts")
  end
end
