class TheNiemCoreXmlElementGenerator
  
  
  # In parameter lists, (o) means the parameter is optional


  def self.new_association_type_node(the_namespace, the_tag_name, the_hash_of_values=nil) #   { starting: {date: <string, CCYY-MM-DD>, margin_of_error(o): <string, PnYnMnDTnHnMnS>},
                                                                                          #     ending:   {date: <string, CCYY-MM-DD>, margin_of_error(o): <string, PnYnMnDTnHnMnS>}    }
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    if( not the_hash_of_values.nil? )
    #AssociationBeginDate                 nc:DateType     .new_date_type_element
      if( the_hash_of_values.key?(:starting) )
        the_new_element << self.new_date_type_element('nc', 'StatusText', the_hash_of_values[:starting])
      end
    #AssociationEndDate                   nc:DateType     .new_date_type_element
      if( the_hash_of_values.key?(:ending) )
        the_new_element << self.new_date_type_element('nc', 'StatusText', the_hash_of_values[:ending])
      end
    end
    
    return the_new_element
  end




  def self.new_status_type_element(the_namespace, the_tag_name, the_hash_of_values=nil) #   {
                                                                                        #     status(o):      {string: <string>, partial_indicator(o): <Ruby boolean>, truncation_indicator(o): <Ruby boolean>},
                                                                                        #     date(o):        {date: <string, CCYY-MM-DD>, margin_of_error(o): <string, PnYnMnDTnHnMnS>},
                                                                                        #     description(o): {string: <string>, partial_indicator(o): <Ruby boolean>, truncation_indicator(o): <Ruby boolean>},
                                                                                        #     issuer(o):      {string: <string>, partial_indicator(o): <Ruby boolean>, truncation_indicator(o): <Ruby boolean>},
                                                                                        #   }
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    if( not the_hash_of_values.nil? )
    #StatusText                 nc:TextType     .new_text_type_element
      if( the_hash_of_values.key?(:status) )
        the_new_element << new_text_type_element('nc', 'StatusText', the_hash_of_values[:status])
      end
    #StatusDate                 nc:DateType     .new_date_type_element
      if( the_hash_of_values.key?(:date) )
        the_new_element << new_date_type_element('nc', 'StatusDate', the_hash_of_values[:date])
      end
    #StatusDescriptionText      nc:TextType     .new_text_type_element
      if( the_hash_of_values.key?(:description) )
        the_new_element << new_text_type_element('nc', 'StatusDescriptionText', the_hash_of_values[:description])
      end
    #StatusIssuerText           nc:TextType     .new_text_type_element
      if( the_hash_of_values.key?(:issuer) )
        the_new_element << new_text_type_element('nc', 'StatusIssuerText', the_hash_of_values[:issuer])
      end
    end

    return the_new_element
  
  end

  
  
  def self.new_person_type_element(the_namespace, the_tag_name, the_hash_of_values)
#                                                                {
#                                                                  age: 
#                                                                  {
#                                                                    value:  <number of years>,
#                                                                    units:  <unece:TimeCodeType>
#                                                                  },
#                                                                  birthdate: 
#                                                                  {
#                                                                    date:            <string, CCYY-MM-DD>,
#                                                                    margin_of_error: <string, PnYnMnDTnHnMnS>
#                                                                  },
#                                                                  marital_status: 
#                                                                  {
#                                                                    string: <string>,
#                                                                    partial_indicator(o): <boolean>,
#                                                                    truncation_indicator(o): <boolean>
#                                                                  },
#                                                                  medical_condition: 
#                                                                  {
#                                                                    condition(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    },
#                                                                    cause(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    },
#                                                                    description(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    },
#                                                                    present_indicator(o): <boolean>,
#                                                                    severity(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    },
#                                                                  },
#                                                                  name:
#                                                                  {
#                                                                    first(o): 
#                                                                    {
#                                                                      name:
#                                                                      {
#                                                                        text_info:
#                                                                        {
#                                                                          string: <string>,
#                                                                          partial_indicator(o): <boolean>,
#                                                                          truncation_indicator(o): <boolean>
#                                                                        },
#                                                                        form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                      },
#                                                                      is_an_initial: <boolean>,
#                                                                    },
#                                                                    middle(o): 
#                                                                    {
#                                                                      name:
#                                                                      {
#                                                                        text_info:
#                                                                        {
#                                                                          string: <string>,
#                                                                          partial_indicator(o): <boolean>,
#                                                                          truncation_indicator(o): <boolean>
#                                                                        },
#                                                                        form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                      },
#                                                                      is_an_initial: <boolean>,
#                                                                    },
#                                                                    last(o): 
#                                                                    {
#                                                                      name:
#                                                                      {
#                                                                        text_info:
#                                                                        {
#                                                                          string: <string>,
#                                                                          partial_indicator(o): <boolean>,
#                                                                          truncation_indicator(o): <boolean>
#                                                                        },
#                                                                        form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                      },
#                                                                      is_an_initial: <boolean>,
#                                                                    },
#                                                                    suffix(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    }
#                                                                  },
#                                                                  sex: <string, M/F/U>,
#                                                                  social_security_number: 
#                                                                  {
#                                                                    id: <string>, 
#                                                                    jurisdiction(o):
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    }
#                                                                  }
#                                                                }

    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    if( the_hash_of_values.key?(:age) )
      the_new_element << self.new_time_measure_type_element(the_namespace, 'PersonAgeMeasure', the_hash_of_values[:age])
    end
    if( the_hash_of_values.key?(:birthdate) )
      the_new_element << self.new_date_type_element(the_namespace, 'PersonBirthDate', the_hash_of_values[:birthdate])
    end
    if( the_hash_of_values.key?(:marital_status) )
      the_new_element << self.new_text_type_element(the_namespace, 'PersonMaritalStatusText', the_hash_of_values[:marital_status])
    end
    if( the_hash_of_values.key?(:medical_condition) )
      the_new_element << self.new_medical_condition_type_element(the_namespace, 'PersonMedicalCondition', the_hash_of_values[:medical_condition])
    end
    if( the_hash_of_values.key?(:name) )
      the_new_element << self.new_person_name_type_element(the_namespace, 'PersonName', the_hash_of_values[:name])
    end
    if( the_hash_of_values.key?(:sex) )
      the_new_element << XmlGenerationUtilities.new_node_with_a_value(the_namespace, 'PersonSex', the_hash_of_values[:sex])
    end
    if( the_hash_of_values.key?(:social_security_number) )
      the_new_element << self.new_identification_type_element(the_namespace, 'PersonSSNIdentification', the_hash_of_values[:social_security_number])
    end
    return the_new_element    
  end
  
  
  
  def self.new_identification_type_element(the_namespace, the_tag_name, the_hash_of_values=nil)                           #nc
#                                                                      { id:           <string>, 
#                                                                        jurisdiction(o):
#                                                                          { string: <string>,
#                                                                            partial_indicator: <boolean>,
#                                                                            truncation_indicator: <boolean>
#                                                                          }
#                                                                      }
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    if( not the_hash_of_values.nil? )
      if( the_hash_of_values.key?(:id) )
        the_new_element << a_new_identification_id_element(the_hash_of_values[:id])
      end
      if( the_hash_of_values.key?(:jurisdiction) )
        the_new_element << a_new_identification_jurisdiction_element(the_hash_of_values[:jurisdiction])
      end
    end
    return the_new_element
  end

  def self.a_new_identification_id_element(the_value)
    the_new_element = XmlGenerationUtilities.new_node_with_a_value('nc', 'IdentificationID', the_value)
#    the_new_element.content = the_value
    return the_new_element
  end
  
  def self.a_new_identification_jurisdiction_element(the_hash_of_values)
#                                                 { string: <string>,
#                                                   partial_indicator: <boolean>,
#                                                   truncation_indicator: <boolean>
#                                                 }
    the_new_element = TheNiemCoreXmlElementGenerator.new_text_type_element('nc', 'IdentificationJurisdiction', the_hash_of_values)
    return the_new_element
  end






  def self.new_person_name_type_element(the_namespace, the_tag_name, the_hash_of_values)
#                                                                  {
#                                                                    first(o): 
#                                                                    {
#                                                                      name:
#                                                                      {
#                                                                        text_info:
#                                                                        {
#                                                                          string: <string>,
#                                                                          partial_indicator(o): <boolean>,
#                                                                          truncation_indicator(o): <boolean>
#                                                                        },
#                                                                        form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                      },
#                                                                      is_an_initial: <boolean>,
#                                                                    },
#                                                                    middle(o): 
#                                                                    {
#                                                                      name:
#                                                                      {
#                                                                        text_info:
#                                                                        {
#                                                                          string: <string>,
#                                                                          partial_indicator(o): <boolean>,
#                                                                          truncation_indicator(o): <boolean>
#                                                                        },
#                                                                        form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                      },
#                                                                      is_an_initial: <boolean>,
#                                                                    },
#                                                                    last(o): 
#                                                                    {
#                                                                      name:
#                                                                      {
#                                                                        text_info:
#                                                                        {
#                                                                          string: <string>,
#                                                                          partial_indicator(o): <boolean>,
#                                                                          truncation_indicator(o): <boolean>
#                                                                        },
#                                                                        form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                      },
#                                                                      is_an_initial: <boolean>,
#                                                                    },
#                                                                    suffix(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    }
#                                                                  }

    the_full_name_string = ''
    the_sequence_number = 1
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)





    if( the_hash_of_values.key?(:first) )
      the_full_name_string = the_full_name_string + the_hash_of_values[:first][:name][:text_info][:string]
      the_new_element << self.new_person_name_text_type_element(the_namespace, 'PersonGivenName', the_hash_of_values[:first], the_sequence_number)
      the_sequence_number = the_sequence_number + 1
    end
    if( the_hash_of_values.key?(:middle) )
      the_full_name_string = the_full_name_string + ' ' + the_hash_of_values[:middle][:name][:text_info][:string]
      the_new_element << self.new_person_name_text_type_element(the_namespace, 'PersonMiddleName', the_hash_of_values[:middle], the_sequence_number)
      the_sequence_number = the_sequence_number + 1
    end
    if( the_hash_of_values.key?(:last) )
      the_full_name_string = the_full_name_string + ' ' + the_hash_of_values[:last][:name][:text_info][:string]
      the_new_element << self.new_person_name_text_type_element(the_namespace, 'PersonSurName', the_hash_of_values[:last], the_sequence_number)
      the_sequence_number = the_sequence_number + 1
    end
    if( the_hash_of_values.key?(:suffix) )
      the_full_name_string = the_full_name_string + ', ' + the_hash_of_values[:suffix][:string]
      the_new_element << self.new_text_type_element(the_namespace, 'PersonNameSuffixText', the_hash_of_values[:suffix])
    end
    if( not the_full_name_string.empty? )
      the_new_element << self.new_person_name_text_type_element(the_namespace, 'PersonFullName', {name: {text_info: {string: the_full_name_string}}})
    end
    return the_new_element
  end 


  def self.new_person_name_text_type_element(the_namespace, the_tag_name, the_hash_of_values, the_sequence_number=nil)
#                                                                    {
#                                                                      name:
#                                                                      {
#                                                                        text_info:
#                                                                        {
#                                                                          string: <string>,
#                                                                          partial_indicator(o): <boolean>,
#                                                                          truncation_indicator(o): <boolean>
#                                                                        },
#                                                                        form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                      },
#                                                                      is_an_initial: <boolean>,
#                                                                    }
    the_new_element = self.new_proper_name_text_type_element(the_namespace, the_tag_name, the_hash_of_values[:name])
    if( the_hash_of_values.key?(:is_an_initial) )
      the_new_element << self.new_niem_boolean_element(the_namespace, 'personNameInitialIndicator', the_hash_of_values[:is_an_initial])
    end
    if( not the_sequence_number.nil? )
      the_new_element <<  XmlGenerationUtilities.new_node_with_a_value('s', 'sequenceID', the_sequence_number.to_s)
    end
    return the_new_element
  end
    



  
  
  def self.new_medical_condition_type_element(the_namespace, the_tag_name, the_hash_of_values)
#                                                                  {
#                                                                    condition(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    },
#                                                                    cause(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    },
#                                                                    description(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    },
#                                                                    present_indicator(o): <boolean>,
#                                                                    severity(o): 
#                                                                    {
#                                                                      string: <string>,
#                                                                      partial_indicator(o): <boolean>,
#                                                                      truncation_indicator(o): <boolean>
#                                                                    }
#                                                                  }

    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    if( the_hash_of_values.key?(:condition) )
      the_new_element << self.new_text_type_element(the_namespace, 'MedicalConditionText', the_hash_of_values[:condition])
    end
    if( the_hash_of_values.key?(:cause) )
      the_new_element << self.new_text_type_element(the_namespace, 'MedicalConditionCauseText', the_hash_of_values[:cause])
    end
    if( the_hash_of_values.key?(:description) )
      the_new_element << self.new_text_type_element(the_namespace, 'MedicalConditionDescriptionText', the_hash_of_values[:description])
    end
    if( the_hash_of_values.key?(:present_indicator) )
      the_new_element << self.new_niem_boolean_element(the_namespace, 'MedicalConditionPresentIndicator', the_hash_of_values[:present_indicator])
    end
    if( the_hash_of_values.key?(:severity) )
      the_new_element << self.new_text_type_element(the_namespace, 'MedicalConditionSeverityText', the_hash_of_values[:severity])
    end
    return the_new_element
  end 
  
  
  
  def self.new_date_type_element(the_namespace, the_tag_name, the_hash_of_values) # {date: <string, CCYY-MM-DD>}, margin_of_error: <string, PnYnMnDTnHnMnS>}
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    if( the_hash_of_values.key?(:date) )
      the_new_element << XmlGenerationUtilities.new_node_with_a_value(the_namespace, 'DateRepresentation', the_hash_of_values[:date])
    end
    if( the_hash_of_values.key?(:margin_of_error) )
      the_new_element << XmlGenerationUtilities.new_node_with_a_value(the_namespace, 'MarginDuration', the_hash_of_values[:margin_of_error])
    end
    return the_new_element
  end 

  def self.new_time_measure_type_element(the_namespace, the_tag_name, the_hash_of_values)
    the_new_element = self.new_measure_type_element(the_namespace, the_tag_name, the_hash_of_values[:value])
    if( the_hash_of_values.key?(:units) )
      the_new_element << XmlGenerationUtilities.new_node_with_a_value(the_namespace, 'TimeUnitCode', the_hash_of_values[:units])
    end
    return the_new_element
  end    
    
  def self.new_measure_type_element(the_namespace, the_tag_name, the_value=nil)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    if( not the_value.nil? )
      the_new_element << XmlGenerationUtilities.new_node_with_a_value(the_namespace, 'MeasureValue', the_value)
    end
    return the_new_element
  end 
  
  
  
  def self.new_contact_information_type_element(the_namespace, the_tag_name, the_hash_of_values)
#                                                                            {
#                                                                              means:              <string>,
#                                                                              entity:             <string>,
#                                                                              entity_description:
#                                                                              {
#                                                                                string:                  <string>
#                                                                                partial_indicator(o):    <boolean>,
#                                                                                 truncation_indicator(o): <boolean>
#                                                                              },
#                                                                              information_description: 
#                                                                              {
#                                                                                string:                  <string>
#                                                                                partial_indicator(o):    <boolean>,
#                                                                                truncation_indicator(o): <boolean>
#                                                                              },
#                                                                              responder: 
#                                                                              {
#                                                                                first(o): 
#                                                                                {
#                                                                                  name:
#                                                                                  {
#                                                                                    text_info:
#                                                                                    {
#                                                                                      string: <string>,
#                                                                                      partial_indicator(o): <boolean>,
#                                                                                      truncation_indicator(o): <boolean>
#                                                                                    },
#                                                                                    form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                                  },
#                                                                                  is_an_initial: <boolean>,
#                                                                                },
#                                                                                middle(o): 
#                                                                                {
#                                                                                  name:
#                                                                                  {
#                                                                                    text_info:
#                                                                                    {
#                                                                                      string: <string>,
#                                                                                      partial_indicator(o): <boolean>,
#                                                                                      truncation_indicator(o): <boolean>
#                                                                                    },
#                                                                                    form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                                  },
#                                                                                  is_an_initial: <boolean>,
#                                                                                },
#                                                                                last(o): 
#                                                                                {
#                                                                                  name:
#                                                                                  {
#                                                                                    text_info:
#                                                                                    {
#                                                                                      string: <string>,
#                                                                                      partial_indicator(o): <boolean>,
#                                                                                      truncation_indicator(o): <boolean>
#                                                                                    },
#                                                                                    form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType>,
#                                                                                  },
#                                                                                  is_an_initial: <boolean>,
#                                                                                },
#                                                                                suffix(o): 
#                                                                                {
#                                                                                  string: <string>,
#                                                                                  partial_indicator(o): <boolean>,
#                                                                                  truncation_indicator(o): <boolean>
#                                                                                }
#                                                                              }
#                                                                            }
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    if( the_hash_of_values.key?(:means) )
      the_new_element << XmlGenerationUtilities.new_node_with_a_value(the_namespace, 'ContactMeans', the_hash_of_values[:means])
    end
    if( the_hash_of_values.key?(:entity) )
      the_new_element << self.new_contact_entity_element(the_namespace, 'ContactEntity', the_hash_of_values[:entity])
    end
    if( the_hash_of_values.key?(:entity_description) )
      the_new_element << self.new_text_type_element(the_namespace, 'ContactEntityDescriptionText', the_hash_of_values[:entity_description])
    end
    if( the_hash_of_values.key?(:information_description) )
      the_new_element << self.new_text_type_element(the_namespace, 'ContactInformationDescriptionText', the_hash_of_values[:information_description])
    end
    if( the_hash_of_values.key?(:responder) )
      the_new_element << self.new_person_type_element(the_namespace, 'ContactResponder', the_hash_of_values[:responder])
    end
    return the_new_element
  end
  

  def self.new_contact_entity_element(the_namespace, the_tag_name, the_entity_string)
    return self.new_entity_type_element(the_namespace, the_tag_name, the_entity_string)
  end

  def self.new_entity_type_element(the_namespace, the_tag_name, the_entity_string)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element << XmlGenerationUtilities.new_node_with_a_value(the_namespace, 'EntityRepresentation', the_entity_string)
    return the_new_element
  end
    
  
  
  
  
  def self.new_location_type_element(the_namespace, the_tag_name, the_address_value_string)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element << self.new_address_type_element(the_namespace, 'LocationAddress', the_address_value_string)
    return the_new_element
  end

  def self.new_address_type_element(the_namespace, the_tag_name, the_address_value_string)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element << XmlGenerationUtilities.new_node_with_a_value(the_namespace, 'AddressRepresentation', the_address_value_string)
    return the_new_element
  end


  
  
  def self.new_proper_name_text_type_element(the_namespace, the_tag_name, the_hash_of_values=nil)
#                                                                            {
#                                                                              text_info:
#                                                                                {
#                                                                                  string: <string>,
#                                                                                  partial_indicator(o): <boolean>,
#                                                                                  truncation_indicator(o): <boolean>
#                                                                                },
#                                                                              form_code(o): <twpdes:ProperNameFormCategoryCodeSimpleType> #TBD
#                                                                            }
    the_new_element = self.new_text_type_element(the_namespace, the_tag_name, the_hash_of_values[:text_info])   
    if( the_hash_of_values.key?(:form_code) )
      the_new_element << self.new_form_code_element(the_namespace, 'formCode', the_hash_of_values[:form_code])
    end
    return the_new_element
  end
  
  def self.new_form_code_element(the_namespace, the_tag_name, the_form_code_value) # twpdes:ProperNameFormCategoryCodeSimpleType
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element.content = the_form_code_value
    return the_new_element
  end
    
  def self.new_text_type_element(the_namespace, the_tag_name, the_hash_of_values) #{string: <text content>, partial_indicator(o): <Ruby boolean>, truncation_indicator(o): <Ruby boolean>}
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element.content = the_hash_of_values[:string]
    if( the_hash_of_values.key?(:partial_indicator) )
      the_new_element << self.new_partial_indicator_element(the_hash_of_values[:partial_indicator])
    end
    if( the_hash_of_values.key?(:truncation_indicator) )
      the_new_element << self.new_truncation_indicator_element(the_hash_of_values[:truncation_indicator])
    end
    return the_new_element
  end
  
  def self.new_partial_indicator_element(the_value)
    the_new_element = XmlGenerationUtilities.new_node('nc', 'partialIndicator')
    the_new_element.content = self.niem_boolean_value_corresponding_to(the_value)
    return the_new_element
  end
    
  def self.new_truncation_indicator_element(the_value)
    the_new_element = XmlGenerationUtilities.new_node('nc', 'truncationIndicator')
    the_new_element.content = self.niem_boolean_value_corresponding_to(the_value)
    return the_new_element
  end

  def self.new_niem_boolean_element(the_namespace, the_tag_name, the_ruby_boolean_value)
    the_new_element = XmlGenerationUtilities.new_node(the_namespace, the_tag_name)
    the_new_element.content = self.niem_boolean_value_corresponding_to(the_ruby_boolean_value)
    return the_new_element
  end

  def self.niem_boolean_value_corresponding_to(the_ruby_boolean_value)
    if( the_ruby_boolean_value )
      return 'true'
    else
      return 'false'
    end
  end  

  
end
