#!/bin/env ruby
## encoding: utf-8

# SMELL: This model does not seem to be used in the code and should probably be removed

class TheEvaluationContentManagerInitializer
  
  
  def self.associates_major_systems_with_templates
    
    THE_SET_OF_MAJOR_SYSTEM_AND_EVALUATION_TEMPLATE_ASSOCIATIONS.each do |the_association_to_create|

      the_major_system = MajorSystem.find_by(name: the_association_to_create[ :major_system_name ] )
      the_evaluation_template = EvaluationTemplate.find_by(name: the_association_to_create[ :evaluation_template_name ] )
      the_major_system.evaluation_template_id = the_evaluation_template.id
      the_major_system.save

    end

  end
  

  def self.associates_minor_systems_with_major_systems
    
    THE_SET_OF_MINOR_SYSTEM_AND_MAJOR_SYSTEM_ASSOCIATIONS.each do |the_association_to_create|

      the_minor_system = MinorSystem.find_by(name: the_association_to_create[ :minor_system_name ] )
      the_major_system = MajorSystem.find_by(name: the_association_to_create[ :major_system_name ] )
      the_minor_system.major_system_id = the_major_system.id
      the_minor_system.save

    end

  end
  

  def self.creates_the_evaluation_templates

    EvaluationTemplate.destroy_all
    
    THE_SET_OF_EVALUATION_TEMPLATE_VALUES.each do |the_evaluation_template_to_create|

      EvaluationTemplate.create(the_evaluation_template_to_create)

    end
  end


  def self.creates_the_major_systems

    MajorSystem.destroy_all
    
    THE_SET_OF_MAJOR_SYSTEM_VALUES.each do |the_major_system_to_create|

      MajorSystem.create(the_major_system_to_create)

    end
  end


  def self.creates_the_minor_systems

    MinorSystem.destroy_all

    THE_SET_OF_MINOR_SYSTEM_VALUES.each do |the_minor_system_to_create|

      MinorSystem.create(the_minor_system_to_create)

    end
  end
  
  
  def self.does_it_all
    self.creates_the_evaluation_templates
    self.creates_the_major_systems
    self.creates_the_minor_systems
    
    self.associates_major_systems_with_templates
    self.associates_minor_systems_with_major_systems
  end
  
  
private

  THE_SET_OF_MINOR_SYSTEM_AND_MAJOR_SYSTEM_ASSOCIATIONS =
  [
    { minor_system_name: "chronic_diseases",                   major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "prosthetic_implants",                major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "amputations_upper_extremity",        major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "amputations_lower_extremity",        major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "shoulder_and_arm",                   major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "elbow_and_forearm",                  major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "wrist",                              major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "ankylosis",                          major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "spine",                              major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "hip_and_thigh",                      major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "knee_and_leg",                       major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "ankle",                              major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "shortening_lower_extremity",         major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "foot",                               major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "skull",                              major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "ribs",                               major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "coccyx",                             major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "muscle_shoulder_girdle_and_arm",     major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "muscle_forearm_and_hand",            major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "muscle_pelvic_girdle_and_thigh",     major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "muscle_torso_and_neck",              major_system_name: "musculoskeletal_system"                          },
    { minor_system_name: "musculoskeletal_miscellaneous",      major_system_name: "musculoskeletal_system"                          },
    
    { minor_system_name: "eye_diseases",                       major_system_name: "organs_of_special_sense"                         },
    { minor_system_name: "impairment_central_visual_acuity",   major_system_name: "organs_of_special_sense"                         },
    { minor_system_name: "impairment_visual_fields",           major_system_name: "organs_of_special_sense"                         },
    { minor_system_name: "impairment_muscle_function",         major_system_name: "organs_of_special_sense"                         },
    
    { minor_system_name: "diseases_ear",                       major_system_name: "impairment_of_auditory_acuity"                   },
    { minor_system_name: "other_sense_organs",                 major_system_name: "impairment_of_auditory_acuity"                   },
    
    { minor_system_name: "infectious_diseases",                major_system_name: "infectious_diseases"                             },
    
    { minor_system_name: "nose_and_throat",                    major_system_name: "respiratory_system"                              },
    { minor_system_name: "trachea_and_bronchi",                major_system_name: "respiratory_system"                              },
    { minor_system_name: "lungs_and_pleura_tuberculosis",      major_system_name: "respiratory_system"                              },
    { minor_system_name: "nontuberculous_diseases",            major_system_name: "respiratory_system"                              },
    { minor_system_name: "lung_bacterial_infections",          major_system_name: "respiratory_system"                              },
    { minor_system_name: "lung_disease_interstitial",          major_system_name: "respiratory_system"                              },
    { minor_system_name: "lung_disease_mycotic",               major_system_name: "respiratory_system"                              },
    { minor_system_name: "lung_disease_restrictive",           major_system_name: "respiratory_system"                              },
    
    { minor_system_name: "heart",                              major_system_name: "cardiovascular_system"                           },
    { minor_system_name: "arteries_and_veins",                 major_system_name: "cardiovascular_system"                           },
    
    { minor_system_name: "digestive_system",                   major_system_name: "digestive_system"                                },
    
    { minor_system_name: "genitourinary_system",               major_system_name: "genitourinary_system"                            },
    
    { minor_system_name: "gynecological_and_breast",           major_system_name: "gynecological_and_breast"                        },
    
    { minor_system_name: "hemic_and_lymphatic",                major_system_name: "hemic_and_lymphatic_systems"                     },
    
    { minor_system_name: "skin",                               major_system_name: "skin"                                            },

    { minor_system_name: "endocrine_system",                   major_system_name: "endocrine_system"                                },
    
    { minor_system_name: "central_nervous_system_organic",     major_system_name: "neurological_conditions"                         },
    { minor_system_name: "neurological_miscellaneous",         major_system_name: "neurological_conditions"                         },
    { minor_system_name: "cranial_nerves",                     major_system_name: "neurological_conditions"                         },
    { minor_system_name: "peripheral_nerves",                  major_system_name: "neurological_conditions"                         },
    { minor_system_name: "epilepsies",                         major_system_name: "neurological_conditions"                         },
    
    { minor_system_name: "mental_disorders",                   major_system_name: "mental_disorders"                                },
    
    { minor_system_name: "dental_and_oral_conditions",         major_system_name: "dental_and_oral_conditions"                      }
  ]



  THE_SET_OF_MAJOR_SYSTEM_AND_EVALUATION_TEMPLATE_ASSOCIATIONS =
  [
    { major_system_name: "musculoskeletal_system",        evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "organs_of_special_sense",       evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "impairment_of_auditory_acuity", evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "infectious_diseases",           evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "respiratory_system",            evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "cardiovascular_system",         evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "digestive_system",              evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "genitourinary_system",          evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "gynecological_and_breast",      evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "hemic_and_lymphatic_systems",   evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "skin",                          evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "endocrine_system",              evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "neurological_conditions",       evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "mental_disorders",              evaluation_template_name: "full_body_evaluation" },
    { major_system_name: "dental_and_oral_conditions",    evaluation_template_name: "full_body_evaluation" }
  ]


  THE_SET_OF_EVALUATION_TEMPLATE_VALUES =
  [
    { name: "full_body_evaluation", label: "Full Body Evaluation" }
  ]
    

  THE_SET_OF_MAJOR_SYSTEM_VALUES =
  [
    { name: "musculoskeletal_system",         label: "MUSCULOSKELETAL SYSTEM"                                               },
    { name: "organs_of_special_sense",        label: "ORGANS OF SPECIAL SENSE"                                              },
    { name: "impairment_of_auditory_acuity",  label: "IMPAIRMENT OF AUDITORY ACUITY"                                        },
    { name: "infectious_diseases",            label: "INFECTIOUS DISEASES, IMMUNE DISORDERS, AND NUTRITIONAL DEFICIENCIES"  },
    { name: "respiratory_system",             label: "RESPIRATORY SYSTEM"                                                   },
    { name: "cardiovascular_system",          label: "CARDIOVASCULAR SYSTEM"                                                },
    { name: "digestive_system",               label: "DIGESTIVE SYSTEM"                                                     },
    { name: "genitourinary_system",           label: "GENITOURINARY SYSTEM"                                                 },
    { name: "gynecological_and_breast",       label: "GYNECOLOGICAL CONDITIONS AND DISORDERS OF THE BREAST"                 },
    { name: "hemic_and_lymphatic_systems",    label: "HEMIC AND LYMPHATIC SYSTEMS"                                          },
    { name: "skin",                           label: "SKIN"                                                                 },
    { name: "endocrine_system",               label: "ENDOCRINE SYSTEM"                                                     },
    { name: "neurological_conditions",        label: "NEUROLOGICAL CONDITIONS AND CONVULSIVE DISORDERS"                     },
    { name: "mental_disorders",               label: "MENTAL DISORDERS"                                                     },
    { name: "dental_and_oral_conditions",     label: "DENTAL AND ORAL CONDITIONS"                                           }
  ]
  
  
  THE_SET_OF_MINOR_SYSTEM_VALUES =
  [
    { name: "chronic_diseases",                   label: "Acute, Subacute, or Chronic Diseases"                                                 },
    { name: "prosthetic_implants",                label: "Prosthetic Implants"                                                                  },
    { name: "amputations_upper_extremity",        label: "Amputations: Upper Extremity"                                                         },
    { name: "amputations_lower_extremity",        label: "Amputations: Lower Extremity"                                                         },
    { name: "shoulder_and_arm",                   label: "Shoulder and Arm"                                                                     },
    { name: "elbow_and_forearm",                  label: "Elbow and Forearm"                                                                    },
    { name: "wrist",                              label: "Wrist"                                                                                },
    { name: "ankylosis",                          label: "Ankylosis or Limitation of Motion of Single or Multiple Digits of the Hand"           },
    { name: "spine",                              label: "Spine"                                                                                },
    { name: "hip_and_thigh",                      label: "Hip and Thigh"                                                                        },
    { name: "knee_and_leg",                       label: "Knee and Leg"                                                                         },
    { name: "ankle",                              label: "Ankle"                                                                                },
    { name: "shortening_lower_extremity",         label: "Shortening of the Lower Extremity"                                                    },
    { name: "foot",                               label: "Foot"                                                                                 },
    { name: "skull",                              label: "Skull"                                                                                },
    { name: "ribs",                               label: "Ribs"                                                                                 },
    { name: "coccyx",                             label: "Coccyx"                                                                               },
    { name: "muscle_shoulder_girdle_and_arm",     label: "Shoulder Girdle and Arm – Muscle"                                                     },
    { name: "muscle_forearm_and_hand",            label: "Forearm and Hand – Muscle"                                                            },
    { name: "muscle_pelvic_girdle_and_thigh",     label: "Pelvic Girdle and Thigh – Muscle"                                                     },
    { name: "muscle_torso_and_neck",              label: "Torso and Neck – Muscle"                                                              },
    { name: "musculoskeletal_miscellaneous",      label: "Miscellaneous"                                                                        },
    
    { name: "eye_diseases",                       label: "Diseases of the Eye"                                                                  },
    { name: "impairment_central_visual_acuity",   label: "Impairment of Central Visual Acuity"                                                  },
    { name: "impairment_visual_fields",           label: "Impairment of Visual Fields"                                                          },
    { name: "impairment_muscle_function",         label: "Impairment of Muscle Function"                                                        },
    
    { name: "diseases_ear",                       label: "Diseases of the Ear"                                                                  },
    { name: "other_sense_organs",                 label: "Other Sense Organs"                                                                   },
    
    { name: "infectious_diseases",                label: "Infectious Diseases, Immune Disorders, and Nutritional Deficiencies"                  },
    
    { name: "nose_and_throat",                    label: "Diseases of the Nose and Throat"                                                      },
    { name: "trachea_and_bronchi",                label: "Diseases of the Trachea and Bronchi"                                                  },
    { name: "lungs_and_pleura_tuberculosis",      label: "Diseases of the Lungs and Pleura – Tuberculosis"                                      },
    { name: "nontuberculous_diseases",            label: "Nontuberculous Diseases"                                                              },
    { name: "lung_bacterial_infections",          label: "Bacterial Infections of the Lung"                                                     },
    { name: "lung_disease_interstitial",          label: "Interstitial Lung Disease"                                                            },
    { name: "lung_disease_mycotic",               label: "Mycotic Lung Disease"                                                                 },
    { name: "lung_disease_restrictive",           label: "Restrictive Lung Disease"                                                             },
    
    { name: "heart",                              label: "Diseases of the Heart"                                                                },
    { name: "arteries_and_veins",                 label: "Diseases of the Arteries and Veins"                                                   },
    
    { name: "digestive_system",                   label: "Digestive System"                                                                     },
    
    { name: "genitourinary_system",               label: "Genitourinary System"                                                                 },
    
    { name: "gynecological_and_breast",           label: "Gynecological Conditions and Disorders of the Breast"                                 },
    
    { name: "hemic_and_lymphatic",                label: "Hemic and Lymphatic Systems"                                                          },
    
    { name: "skin",                               label: "Skin"                                                                                 },

    { name: "endocrine_system",                   label: "Endocrine System"                                                                     },
    
    { name: "central_nervous_system_organic",     label: "Organic Diseases of the Central Nervous System"                                       },
    { name: "neurological_miscellaneous",         label: "Miscellaneous Diseases"                                                               },
    { name: "cranial_nerves",                     label: "Diseases of the Cranial Nerves"                                                       },
    { name: "peripheral_nerves",                  label: "Diseases of the Peripheral Nerves"                                                    },
    { name: "epilepsies",                         label: "Epilepsies"                                                                           },
    
    { name: "mental_disorders",                   label: "Mental Disorders"                                                                     },
    
    { name: "dental_and_oral_conditions",         label: "Dental and Oral Conditions"                                                           }
  ]
  
  
  
  
  
  
  
  
  THE_SET_OF_VBMS_R_FACT_GROUP_VALUES =
  {
    1 =>  {
            id: 1,
            name: "Gynecological Disorders",
            namespace: "gyf",
            fact_block_tag_name: "gynecologicalFacts",
            diagnosis_tag_name: "gynecologicalDiagnoses",
            symptom_tag_name: "gynecologicalSymptoms",
            document_title: "VA Disability Assessment Gynecological Disorders",
            diagnosis_info:
            {
              "7623" => "Surgical complications of pregnancy"
            },
            symptom_info:
            {
              "cystocele" => "Surgical complications of pregnancy with cystocele",
              "rectocele" => "Surgical complication of pregnancy with rectocele",
              "relaxation_of_perineum" => "Surgical complications of pregnancy with relaxation of perineum"
            }
          },
    2 =>  {
            id: 2,
            name: "Mental Disorders",
            namespace: "mdf",
            fact_block_tag_name: "mentalDisorderFacts",
            diagnosis_tag_name: "mentalDisorderDiagnoses",
            symptom_tag_name: "mentalDisorderSymptoms",
            document_title: "VA Disability Assessment Mental Disorders",
            diagnosis_info:
            {
              "9404" => "Obsessive compulsive disorder"
            },
#            diagnosis_modifier_info: (should be 'other element info' here? Diagnosis Modifier is on the evaluation side)
#            {
#              'Severe enough for release' => { '9404' => { diagnosis_modifier_tag_name: "severeEnoughForRelease", value: true } }
#            },
            symptom_info:
            {
              "anxiety" => "Anxiety",
            }
          },
    3 =>  {
            id: 3,
            name: "Knee",
            namespace: "kf",
            fact_block_tag_name: "kneeFacts",
            diagnosis_tag_name: "jointsOtherDiagnoses",
            symptom_tag_name: "kneeSymptoms",
            document_title: "VA Disability Assessment Knee",
            diagnosis_info:
            {
              "5010" => "Arthritis, traumatic"
            },
            symptom_info:
            {
              "laxity" => "Laxity shown, but without recurrent subluxation or instability",
              "painful_flexion" => "Painful Flexion",
              "painful_extension" => "Painful Extension",
              "patellar_subluxation" => "patellar subluxation"
            }
          },
    4 =>  {
            id: 4,
            name: "Scars",
            namespace: "TBD",
            fact_block_tag_name: "TBD",
            diagnosis_tag_name: "TBD",
            symptom_tag_name: "TBD",
            document_title: "VA Disability Assessment Scars",
            diagnosis_info:
            {
#              "7623" => "Surgical complications of pregnancy"
            },
            symptom_info:
            {
#              "cystocele" => "Surgical complications of pregnancy with cystocele",
#              "rectocele" => "Surgical complication of pregnancy with rectocele",
#              "relaxation_of_perineum" => "Surgical complications of pregnancy with relaxation of perineum"
            }
          },
    5 =>  {
            id: 5,
            name: "Scars (Extremities and Trunk)",
            namespace: "setfl",
            fact_block_tag_name: "scarExtremitiesTrunkFactsList",   # ExamResponse-4.0.xsd, ScarExtremitesTrunkFactsList-1.2.xsd
            diagnosis_tag_name: "",
            symptom_tag_name: "",
            document_title: "VA Disability Assessment Scars (Extremities and Trunk)",
            diagnosis_info:
            {
#              "7623" => "Surgical complications of pregnancy"
            },
            symptom_info:
            {
#              "cystocele" => "Surgical complications of pregnancy with cystocele",
#              "rectocele" => "Surgical complication of pregnancy with rectocele",
#              "relaxation_of_perineum" => "Surgical complications of pregnancy with relaxation of perineum"
            }
          }
  }
  
end
