# == Schema Information
#
# Table name: site_role_sets
#
#  id              :integer          not null, primary key
#  user_id         :integer
#  site_id         :integer
#  admin           :boolean          default(FALSE), not null
#  triage          :boolean          default(FALSE), not null
#  scheduling      :boolean          default(FALSE), not null
#  clinician       :boolean          default(FALSE), not null
#  super_clinician :boolean          default(FALSE), not null
#  qa              :boolean          default(FALSE), not null
#  created_at      :datetime         not null
#  updated_at      :datetime         not null
#  vha_cc          :boolean          default(FALSE), not null
#  non_vha         :boolean          default(FALSE), not null
#

# SMELL: This model does not seem to be used in the code and should probably be removed

class SiteRoleSet < ActiveRecord::Base
    
    belongs_to :user
    belongs_to :site
    
    def get_roles_string
      role_string = ""
      self.admin ? role_string += " < Admin > " : false
      self.triage ? role_string += " < Triage > " : false
      self.scheduling ? role_string += " < Scheduling > " : false
      self.clinician ? role_string += " < Clinician > " : false
      self.super_clinician ? role_string += " < Supervisory Clinician > " : false
      self.qa ? role_string += " < Quality Assurance > " : false
      self.vha_cc ? role_string += " < VHA CC > " : false
      self.non_vha ? role_string += " < Non VHA >" : false
      if role_string.length > 2
        return role_string
      else
        return nil
      end
    end
    
    def any_roles?
      if get_roles_string && get_roles_string.length > 2
        return true
      else
        return false
      end
    end
    
end
