# == Schema Information
#
# Table name: referral_document_types
#
#  id         :integer          not null, primary key
#  sequence   :string           not null
#  title      :string           not null
#  deleted_at :datetime
#

class ReferralDocumentType < ActiveRecord::Base
  has_many :referral_documents
  acts_as_paranoid

  class << self
    def to_dropdown
      all.map do |ref_doc_type|
        [ref_doc_type.title, ref_doc_type.id]
      end
    end
  end

end
