# == Schema Information
#
# Table name: referral_appointment_statuses
#
#  id         :integer          not null, primary key
#  sequence   :string           not null
#  title      :string           not null
#  deleted_at :datetime
#

class ReferralAppointmentStatus < ActiveRecord::Base

	has_many :referral_appointments
	acts_as_paranoid

	#This constant is used to send the Referral Appoitments to VistA if Referral Appointment Status is Confirmed.
	ADD_TO_CPRS_STATUS = 'Confirmed'.freeze
	NEW_STATUS = 'New'.freeze

	class << self
		def for_vha_cc
			all.map do |ref_app_status|
				[ref_app_status.title, ref_app_status.id]
			end
		end

		def for_non_vha
			list = all.select {|x| x.title != ADD_TO_CPRS_STATUS}
			list.map do |ref_app_status|
				[ref_app_status.title, ref_app_status.id]
			end
		end
	end

end
