# == Schema Information
#
# Table name: notifications
#
#  id         :integer          not null, primary key
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

class Notification < ActiveRecord::Base
  attr_accessor :document

  def validate_xml
    xsd_path = Rails.root.join("app", "xsd", "ExamManagement", "exchange", "ExamManagement-2.0.xsd")
    xsd = Nokogiri::XML::Schema(File.open(xsd_path))
    #self.to_xml
    doc = Nokogiri::XML(self.to_xml)
    xsd.validate(doc).map { |error| error.message }
  end

  def to_xml
    @document.to_xml
  end
end
