# == Schema Information
#
# Table name: dbq_sections
#
#  id                                    :integer
#  title                                 :string				# Section title
#  section_type                          :string				# Type of section ["ace", "diagnosis", "symptoms", "evidence review", etc] (Will likely change this to a has_one/belongs_to_many model so future changes to names of sections are easily accommodated)
#  created_at                            :datetime
#  updated_at                            :datetime


class DbqSection < ActiveRecord::Base

  belongs_to :dbq_form

  # TODO: Use the order_num attribute and order the dbq_elements using that column
  has_many :dbq_elements, -> { order "id" }, dependent: :destroy
  accepts_nested_attributes_for :dbq_elements, :allow_destroy => true

end
