# == Schema Information
#
# Table name: dbq_forms
#
#  id                                    :integer
#  name                                  :string            # Primary identifier. Corresponds with DBQ names in IEPD ExamRequest messages
#  title                                 :string            # Title to display on Form (may differ from name)
#  series_id                             :float             # If the IEPD name ever changes, the series_id will stay the same for all past and future versions of this DBQ
#  version                               :float             # Version numbers to track changes of particular DBQ
#  status                                :integer (enum)    # [:inactive, :pending, :in_progress, :complete]
#  archived                              :boolean           # Is this DBQ archived?
#  template                              :boolean           # Is this DBQ a template?
#  created_at                            :datetime
#  updated_at                            :datetime


class DbqForm < ActiveRecord::Base
  belongs_to :examination
  # TODO: Use the order_num attribute and order the dbq_sections using that column
  has_many :dbq_sections, -> { order "id" }, dependent: :destroy
  accepts_nested_attributes_for :dbq_sections, :allow_destroy => true

  enum status: [:inactive, :pending, :in_progress, :complete]

  scope :all_templates, -> { where(template: true) }
  scope :all_archived,  -> { where(archived: true) }


  def deep_dup
    dbq_dup = self.dup
    self.dbq_sections.each do |s|
      section_dup = s.dup
      s.dbq_elements.each do |e|
        element_dup = e.dup
        section_dup.dbq_elements << element_dup
      end
      dbq_dup.dbq_sections << section_dup
    end
    dbq_dup.save
    dbq_dup
  end


  def template?
    template
  end


  def archived?
    archived
  end

end # class DbqForm < ActiveRecord::Base



