# == Schema Information
#
# Table name: dbq_elements
#
#  id                                    :integer
#  order_num                             :integer         		# Order that this element should appear within it's dbq_section
#  element_type                          :string				# Type of element ["label", "text_field", "text_area", "check_box", "radio_button", "check_group", "radio_group", etc]
#  label                                 :text					# Html label for this element
#  value                                 :text					# Value inputed or selected by the clinician for this element
#  possible_values[]                     :text[]				# Range of possible values for Clinician to select. For types like: check_group, radio_group, select, multi-select, etc
#  created_at                            :datetime
#  updated_at                            :datetime

class DbqElement < ActiveRecord::Base

  serialize :value

  belongs_to :dbq_section

  before_save :remove_blank_possible_values


  private

  def remove_blank_possible_values
    possible_values.reject!(&:blank?)
  end

end
