# == Schema Information
#
# Table name: notifications
#
#  id         :integer          not null, primary key
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

class ContentionCancelledEventNotification < Notification
  include ContentionObjectHelper 
  def build_notification(contention, site_id, previousEventId)
    path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'contention_cancelled_event.xml')
    @document = Nokogiri::XML(File.open(path))

    contentionCanceledEvent = XmlHelper.getDoc(@document, 'ContentionCanceledEvent')
    
    contentionObject = getContentionObject(contention.exam_related_contention_id)
    contentionObjectDoc = XmlHelper.convertToDocument(contentionObject.xml)

    site = Site.find_by_id(site_id)
    if (site == nil)
      raise Exception, "Invalid site id ::: " + site_id
    end

    originatingSystemTag = XmlHelper.getDoc(@document, 'OriginatingSystem')
    originatingSystemTag['contractorName'] = site.name

    eventId = SecureRandom.uuid
    contentionCanceledEvent['eventUuid'] = eventId
    contentionCanceledEvent['eventDtg'] = Time.now.utc.iso8601
    contentionCanceledEvent['previousEventUuid'] = previousEventId
    contentionCanceledEvent['modelVersion'] = "2.0"
    contentionCanceledEvent['examRelatedContentionUuid'] = contention.exam_related_contention_id

    reasonForCancellation = XmlHelper.getDoc(contentionCanceledEvent, 'ReasonForCancellation')
    reasonForCancellation.content = contention.reason_for_cancellation
    handleContentionCancelledEvent(contentionCanceledEvent, contention)

    @document.root << contentionCanceledEvent 
    return eventId
  end
end
