# == Schema Information
#
# Table name: notifications
#
#  id         :integer          not null, primary key
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

class ClarificationRequestEvent < Notification

  def build_notification(er_uuid, site_id, user, clarificationRequest)
    path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'clarification_request_event.xml')
    @document = Nokogiri::XML(File.open(path))

    clarification_request_event = XmlHelper.getDoc(@document, 'ClarificationRequestEvent')

    request_object = RequestObject.all.order('created_at desc').find_by_exam_request_uuid(er_uuid)
    request_object_doc = Nokogiri::XML(request_object.xml)

    site = Site.find_by_id(site_id)
    if site.nil?
      raise Exception, "Invalid site id ::: #{site_id}"
    end

    originatingSystemTag = XmlHelper.getDoc(@document, 'OriginatingSystem')
    originatingSystemTag['contractorName'] = site.name

    examSchedulingRequestCreatedEvent = XmlHelper.getDoc(request_object_doc, 'ExamSchedulingRequestCreatedEvent')
    exam_scheduling_request_id = examSchedulingRequestCreatedEvent['examSchedulingRequestUuid']

    event_uuid = SecureRandom.uuid
    clarification_request_event['eventUuid'] = event_uuid
    clarification_request_event['previousEventUuid'] = last_event_in_request_scope_events(request_object_doc)
    clarification_request_event['eventDtg'] = Time.now.utc.iso8601
    clarification_request_event['examSchedulingRequestUuid'] = examSchedulingRequestCreatedEvent['examSchedulingRequestUuid']
    clarification_request_event['dateOfRequest'] = Date.today.to_s
    clarification_request_event['modelVersion'] = "2.0"

    eventSourceTag = XmlHelper.getDoc(clarification_request_event, 'EventSource')
    eventSourceTag['contractorName'] = site.name

    clarificationReasonTag = XmlHelper.getDoc(clarification_request_event, 'ClarificationReason')
    clarificationReasonTag.content = clarificationRequest.clarification_category

    pocPhoneTag = XmlHelper.getDoc(clarification_request_event, 'PointOfContactPhone')
    pocPhoneTag['primaryPhone'] = clarificationRequest.primary
    pocPhoneTag['alternatePhone'] = clarificationRequest.alternate

    contentionClarificationInfo = clarificationRequest.clarificationText

    contention_uuid = nil

    if (contentionClarificationInfo != nil && contentionClarificationInfo.length > 0)
      unclearContentionReferencesTag = XmlHelper.createTag(document, "UnclearContentionReferences")

      contentionClarificationInfo.each do |key, value|
        contentionClarificationRequestTag = XmlHelper.createTag(document, "ContentionClarificationRequest")
        contentionClarificationRequestTag['contentionUuid'] = key
        contention_uuid = contentionClarificationRequestTag['contentionUuid']
        contentionClarificationFreeTextTag = XmlHelper.createTag(document, "ContentionClarificationFreeText")
        contentionClarificationFreeTextTag.content = clarificationRequest.clarificationReason + "---" + value

        contentionClarificationRequestTag << contentionClarificationFreeTextTag

        unclearContentionReferencesTag << contentionClarificationRequestTag
      end
      clarification_request_event << unclearContentionReferencesTag
    end
    @document.root << clarification_request_event

    event_uuid
  end

  def last_event_in_request_scope_events ro_doc
    requestScopeEvents = XmlHelper.getDoc(ro_doc, 'RequestScopeEvents')
    requestScopeEvents.elements.last['eventUuid']
  end
end

