# == Schema Information
#
# Table name: notifications
#
#  id         :integer          not null, primary key
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

class AppointmentCompletedEvent < Notification

  def build_notification(claim_id, contention_id, site_id)
    path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'appointment_completed_event.xml')
    @document = Nokogiri::XML(File.open(path))

    apptCompletedEvent = XmlHelper.getDoc(@document, 'AppointmentCompletedEvent')

    requestObject  = RequestObject.all.order('created_at desc').find_by_claim_id claim_id
    request_object_doc = Nokogiri::XML(requestObject.xml)
    examSchedulingRequestCreatedEvent = XmlHelper.getDoc(request_object_doc, 'ExamSchedulingRequestCreatedEvent')
    
    apptCompletedEvent['examAppointmentUuid'] = SecureRandom.uuid
    # Return event id
    eventId = SecureRandom.uuid
    apptCompletedEvent['eventUuid'] = eventId
    apptCompletedEvent['eventDtg'] = Time.now.utc.iso8601
    apptCompletedEvent['modelVersion'] = examSchedulingRequestCreatedEvent['modelVersion']

    apptObject = AppointmentObject.find_by_contention_id(contention_id)
    if (apptObject != nil)
      appt_scheduled_doc = Nokogiri::XML(apptObject.xml)
      appt_scheduled_event_doc = XmlHelper.getDoc(appt_scheduled_doc.root, 'AppointmentScheduledEvent')
      apptCompletedEvent['previousEventUuid'] = appt_scheduled_event_doc['eventUuid']
    end

    site = Site.find_by_id site_id
  
    eventSourceDoc = XmlHelper.getDoc(apptCompletedEvent, 'EventSource')
    eventSourceDoc['participatingSystemName'] = "VBA Contractor"
    #eventSourceDoc['contractorName'] = site.name

    originatingSystemDoc = XmlHelper.getDoc(@document, 'OriginatingSystem')
    originatingSystemDoc['participatingSystemName'] = "VBA Contractor"
    originatingSystemDoc['contractorName'] = site.name

    @document.root << originatingSystemDoc

    destinationDoc = XmlHelper.getDoc(@document, 'Destination')
    destinationDoc['participatingSystemName'] = "VBMS"

    @document.root << destinationDoc

    @document.root << apptCompletedEvent

    return eventId 
  end


end
