# == Schema Information
#
# Table name: notifications
#
#  id         :integer          not null, primary key
#  created_at :datetime         not null
#  updated_at :datetime         not null
#

class AppointmentCanceledEvent < Notification

  def build_notification(examAppointmentUuid)
    path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'appointment_canceled_event.xml')
    @document = Nokogiri::XML(File.open(path))

    apptCanceledEvent = XmlHelper.getDoc(@document, 'AppointmentCanceledEvent')

    appointmentObject  = AppointmentObject.all.order('created_at desc').find_by_exam_appointment_uuid examAppointmentUuid
    appointmentDoc = Nokogiri::XML(appointmentObject.xml)
    examAppointment = XmlHelper.getDoc(appointmentDoc, 'ExamAppointment')
    
    apptCanceledEvent['examAppointmentUuid'] = examAppointmentUuid
    # Return event id
    eventUuid = SecureRandom.uuid
    apptCanceledEvent['eventUuid'] = eventUuid
    apptCanceledEvent['eventDtg'] = Time.now.utc.iso8601
    apptCanceledEvent['modelVersion'] = "2.0"

    examination = Examination.find_by_identifier appointmentObject.examination_identifier
    site = Site.find_by_id examination.site_id
  
    originatingSystemDoc = XmlHelper.getDoc(@document, 'OriginatingSystem')
    originatingSystemDoc['participatingSystemName'] = "VBA Contractor"
    originatingSystemDoc['contractorName'] = site.name

#    @document.root << originatingSystemDoc

    destinationDoc = XmlHelper.getDoc(@document, 'Destination')
    destinationDoc['participatingSystemName'] = "VBMS"

    @document.root << apptCanceledEvent

    return eventUuid 
  end

end
