class UserMailer < ApplicationMailer

   default from: "PII       "



   SUPPORT_REQUEST_INBOX = ENV['SUPPORT_REQUEST_INBOX']
   ACCOUNT_MGMT_INBOX    = ENV['ACCOUNT_MGMT_INBOX']

   def send_report(region, message)
     custom_from = "PII                    "
     mail(from: custom_from, to: ACCOUNT_MGMT_INBOX, subject: "INFO: #{region} user account creation statistics", body: message)

   end

   def welcome_email(app,email_address, message)
      custom_from = "PII                    "
      welcome_subject = "Welcome to #{app}!"
      mail(from: custom_from, to: email_address, bcc:ACCOUNT_MGMT_INBOX, subject: welcome_subject , body: message)
   end

   def access_request(new_user, app_admin)
      @new_user = new_user
      @app_admin = app_admin
#      mail(to: app_admin.email, subject: 'Request for Access to CUI')
   end

   def access_response(user)
      @user = user
#      mail(to: user.email, subject: 'Response to your Request for Access to CUI')
   end

   def site_access_request(new_user, site_admin, site, roles)
      @new_user = new_user
      @site_admin = site_admin
      @site = site
      @roles = roles
#      mail(to: site_admin.email, subject: 'Request for Access to CUI site: ' + site.name)
   end

   def site_access_response(user, site, roles)
      @user = user
      @site = site
      @roles = roles
#      mail(to: user.email, subject: 'Response to your Request for Access to CUI site: ' + site.name)
   end

   def send_create_examination_email(user)
     @user = user
#     mail(to: user.email, subject: 'Pending Request')
   end

  def send_create_exam_request_email(user)
    @user = user
#    mail(to: user.email, subject: 'New Exam Request')
   end

   def send_support_request_confirmation(sr)
      @support_request = sr
      mail(to: SUPPORT_REQUEST_INBOX,
           from: PII                             ',
           #cc:@sr.customer_email,
           subject: "Issue: " + @support_request.issue_description
      )
   end

   def send_account_unlock_confirmation_email(user_email_address)
      mail(to: user_email_address,
           from: PII                             ',
           cc:SUPPORT_REQUEST_INBOX,
           subject: "Your CUI account has been unlocked!"
      )
   end


end
