module PointlessFeedback
  class FeedbackMailer < ActionMailer::Base
    before_filter :check_sanitize
    default from: ENV['FEEDBACK_EMAIL_USER']

    def check_sanitize
      SanitizeEmail.force_sanitize = FEEDBACK_EMAIL_SANITIZE
    end

    def feedback_email(feedback, user, request_data)
      @feedback    = feedback
      @user        = user
      @request_data = request_data
      to_addr = ENV[user.is_cpp_user? ? 'FEEDBACK_EMAIL_TO_CPP' : 'FEEDBACK_EMAIL_TO_CUI']

      mail(to:  to_addr,
           subject:  "#{ENV['FEEDBACK_EMAIL_SUBJECT']} - #{@feedback[:topic]}")
    end
  end
end
