class VlerDASJob < ActiveJob::Base
  queue_as :rendering

  def self.perform(evaluation)
    evaluation_xml = evaluation.to_xml
    activity_log = EvaluationLog.new(submitted_data: evaluation_xml, evaluation_id: evaluation.id, message: "VLER-DAS evaluation submission")
    validation_errors = evaluation.validate_xml
    if evaluation.complete?
      validation_errors = evaluation.validate_xml
      if validation_errors.empty?
        response = nil
        if 'true' == ENV['DAS_ECRUD_ENABLE_NOTIFICATIONS']
          response = DAS::ECRUD.send_event(notificationXml)
        else
          notification_log.message = "Notification to eCRUD DAS has not been enabled by environemnt variable."
        end
        activity_log.response_body = response
      else
        activity_log.message = validation_errors.join("; ")
      end
    else
      activity_log.message = "Evaluation is not complete."
    end
    activity_log.save
  end

  def self.sendExamResponse(full_body_evaluation)
    full_body_evaluation.exam_responses.each do |the_exam_response_to_send|
      self.builds_and_sends_a_single_exam_response_message( full_body_evaluation.id,
                                                            "cui-#{full_body_evaluation.guid}.xml",
                                                            the_exam_response_to_send               )
    end
#    evaluation_xml = full_body_evaluation.to_xml
#    activity_log = EvaluationLog.new(submitted_data: evaluation_xml, evaluation_id: full_body_evaluation.id, message: "VLER-DAS evaluation submission")
#    url = ENV['VLER_DAS_URL']
#    url = "https://silvervler.va.gov/ecrud/v1/core/examResponse/transform"
#    #validation_errors = evaluation.validate_xml
#    req = build_request(url, evaluation_xml, "cui-#{full_body_evaluation.guid}.xml")
#    response = HTTPI.post(req)
#    activity_log.response_body = response.body
#    activity_log.save
  end

  def self.builds_and_sends_a_single_exam_response_message(the_id, the_file_name, the_exam_response_string)
    activity_log = EvaluationLog.new( submitted_data: the_exam_response_string,
                                      evaluation_id: the_id,
                                      message: "VLER-DAS evaluation submission")
    # TODO: need to add more content than just the filename?
    response = DAS::ECRUD.send_dbq(the_file_name)
    activity_log.response_body = resonse
    activity_log.save
  end

  def self.postNotification(notificationXml)
    if 'true' == ENV['DAS_ECRUD_ENABLE_NOTIFICATIONS']
      DAS::ECRUD.send_event(notificationXml)
    else
      notification_log.message = "Notification to eCRUD DAS has not been enabled by environemnt variable."
    end
  end

  def self.sendNotification(notificationEvent, event_uuid, exam_request_uuid, notification_type)
    if (event_uuid == nil)
      raise Exception, "EventUuid cannot be empty"
    end

    validation_errors = notificationEvent.validate_xml
    notificationXml = notificationEvent.to_xml
    notification_log = NotificationLog.new(submitted_xml_data: notificationXml, event_uuid: event_uuid, exam_request_uuid: exam_request_uuid, message: "eCRUD-DAS notification submission", notification_type: notification_type)
    if validation_errors.empty?
      if notificationXml != nil
        if 'true' == ENV['DAS_ECRUD_ENABLE_NOTIFICATIONS']
          DAS::ECRUD.send_event(notificationXml)
        else
          notification_log.message = "Notification to eCRUD DAS has not been enabled by environemnt variable."
        end
      else
        notification_log.message = "Notification cannot be empty"
      end
    else
      notification_log.message = validation_errors.join("; ")
    end
    notification_log.save
  end

end
