# app/jobs/logrotate_job.rb

require 'open3'

# Execute the logrotate command line utility
class LogrotateJob < ActiveJob::Base
  queue_as :default

  # NOTE: conf file created in config/initializers/logrotate.rb from a template
  CONF = Rails.root + 'etc' + 'logrotate.d' + 'deap_cui_cpp.conf'

  def perform
    command = "logrotate -f #{CONF}"
    stdout, sterr, status = Open3.capture3(ENV, command)
    #system command

    Sidekiq::Logging.logger.error(sterr) if sterr
    Sidekiq::Logging.logger.error(stdout) if stdout
    Sidekiq::Logging.logger.error("Log Rotation complete with a status of #{status}")

  end

end
