class ExamResultsJob < ActiveJob::Base
  queue_as :exam_results

  def perform exam_id
    begin
      @exam = Examination.find(exam_id)

      # In case DAS interface is down, and this is a retry, no need to run exam results helper
      dbqs_for_exam = @exam.contentions.inject(0) {|sum, con| sum += con.dbq_informations.length }
      number_of_doc_reference_ids = @exam.contentions.inject(0) {|sum, con| sum += con.document_reference_ids.length }
      unless dbqs_for_exam == number_of_doc_reference_ids
        ExamResultsHelper.build_exam_results exam_id
      end
    
      @exam.dbq_forms.each do |dbq|
        filename = "#{@exam.file_number}_" + "#{@exam.most_recent_active_appointment.exam_date_time.strftime('%Y%m%d')}_" + "#{dbq.title.parameterize('_')}" + ".xml"
        path = Rails.root.to_s + "/files/exam_results/"
        response = DAS::ECRUD.send_dbq(path + filename)
        write_response_to_notification_log(response, path + filename, @exam)
      end      

    rescue ExamResultsHelper::ExamResultsHelperError, ExamResultsHelper::ExamResultsValidationError, DAS::ECRUD::DasEcrudError, DAS::ECRUD::EcrudFaultError  => e
      notification_log = NotificationLog.create(submitted_xml_data: "ExamResultsWorker raising error",    
                          response_body: e.backtrace,
                          message: e.message)
    end
  end

  private

  def write_response_to_notification_log response, full_filename, exam
    submitted_data = File.read(full_filename)
    er_uuid = exam.exam_request.exam_request_uuid
    notification_log = NotificationLog.create(submitted_xml_data: full_filename,
                        exam_request_uuid: er_uuid, 
                        message: "DAS-eFolder Exam Results submission successful.",
                        response_body: response.status,
                        claim_id: exam.claim_id)
  end
end
