class ContentionResultsPackageJob < ActiveJob::Base
  queue_as :exam_results

  def perform exam_id
    begin

      @exam = Examination.find(exam_id)
 
      @exam.contentions.each do |con|
        if con.document_reference_ids.length != con.dbq_informations.length
          raise "Not all dbqs for contention, #{con.contention_details.name}, and File Number, #{@exam.file_number}, have been completed."
        end
        xml_str = ContentionResultsPackageHelper.build_contention_package con.id

        response = DAS::ECRUD.send_event(xml_str)
        update_request_object con, xml_str
        write_response_to_notification_log(response, xml_str, @exam)
      end
    
    rescue DAS::ECRUD::DasEcrudError, DAS::ECRUD::EcrudFaultError, RuntimeError  => e
      notification_log = NotificationLog.create(response_body: e.backtrace,
                          notification_type: "ResultPackageAvailableEvent",
                          message: e.message)
    end
  end

  private
  def write_response_to_notification_log response, xml, exam
      er_uuid = exam.exam_request.exam_request_uuid
      notification_log = NotificationLog.create(submitted_xml_data: xml,
                          exam_request_uuid: er_uuid, 
                          message: "Result Package Available Event submission to VBMS successful.",
                          response_body: response.status,
                          claim_id: exam.claim_id)
  end

  def update_request_object con, xml
    event_doc = Nokogiri::XML(xml)
    event_str = event_doc.at_xpath('//em:ResultPackageAvailableEvent').to_xml
    ro = RequestObject.find_by_claim_id(con.exam_request.claim_id)
    ro_doc = Nokogiri::XML(ro.xml)
    ro_doc.at_xpath('//em:RequestScopeEvents').add_child(event_str)
    ro.update_attributes(xml: ro_doc.to_xml)
  end

end