class ArrayInput < SimpleForm::Inputs::StringInput
  def input(wrapper_options)
    input_html_options[:type] ||= input_type

    decorative_example = ''

    if object.element_type.include?('check')
      decorative_example = '<input type="checkbox" disabled="true" style="display: inline;" class="cui_decorative_input_field"/>'

    elsif object.element_type.include?('radio')
      decorative_example = '<input type="radio" disabled="true" style="display: inline;" class="cui_decorative_input_field"/>'
    end

    values_count = 0

    existing_values = Array(object.public_send(attribute_name)).map do |array_el|

      values_count += 1

      input_line = '<div>'
      input_line += decorative_example + @builder.text_field(nil, input_html_options.merge(value: array_el, name: "#{object_name}[#{attribute_name}][]", style: 'display: inline-block;'))
      input_line += '</div>'
    end

    if object.element_type.include?("group") || object.element_type.include?("select") || values_count == 0

      existing_values.push('<div>')
      existing_values.push(decorative_example + @builder.text_field(nil, input_html_options.merge(placeholder: "New Value Here", value: nil, name: "#{object_name}[#{attribute_name}][]", style: 'display: inline-block;')))
      existing_values.push('</div>')
    end

    existing_values.join.html_safe
  end

  def input_type
    :text
  end
end