module XmlHelper
  TYPES = [ "ExamSchedulingRequestCreatedEvent",
            "ContentionCancellationRequestedEvent",
            "AppointmentCancelRequestEvent",
            "ExamSchedulingRequestCancellationEvent",
            "RescheduleRequestEvent",
            "ClarificationResponseEvent",
            "ReworkExamSchedulingRequestCreatedEvent",
            "NarrativeClarificationResponseEvent"]

  def self.getDoc(document, tag_name)
    if (document != nil)
      doc = document.at('//em:'+tag_name, 'em' => 'http://va.gov/vler/schemas/vlerSupersetSchema/examManagement/2.0')
      if doc.nil?
        # It might be a nonamespace prefix scenario
        doc = document.at(tag_name)
      end
      return doc
    end
    return nil
  end

  def self.getAll(document, tag_name)
    entries = document.xpath('//em:'+tag_name, 'em' => 'http://va.gov/vler/schemas/vlerSupersetSchema/examManagement/2.0')
    return entries
  end

  def self.createTag(document, tag_name)
    tag = Nokogiri::XML::Node.new("em:"+tag_name, document)
    tag
  end

  def self.get_content_type(notification_doc)
    content_type = ""

    if (notification_doc != nil &&
        notification_doc.at('feed/entry/content') != nil &&
        notification_doc.at('feed/entry/content').first_element_child != nil)

      content_typeDoc = notification_doc.at('feed/entry/content').first_element_child
      thirdChild = content_typeDoc.children[2]

      if (thirdChild != nil)
        tag_name = thirdChild.name
        if TYPES.include? tag_name
          content_type = tag_name
        end
      end

      if (content_type.nil? || content_type == "")
        sixthChild = content_typeDoc.children[5]
        if (sixthChild != nil)
          tag_name = sixthChild.name
          if (TYPES.include? tag_name)
            content_type = tag_name
          end
        end
      end

      if (content_type.nil? || content_type == "")
        raise Exception, "Invalid Notification Type"
      end
    end

    content_type = self.narrtive_clarification_response_check(notification_doc) if content_type.blank?
    return content_type
  end

  def self.convertToDocument(xml)
    return Nokogiri::XML(xml)
  end

  def self.getNode(xml,node_name)
    node = XmlHelper.getDoc(XmlHelper.convertToDocument(xml), node_name)
  end

  def self.narrtive_clarification_response_check(notification_doc, content_type="")
    if ( notification_doc != nil &&
         notification_doc.at("//em:ExamManagementEventNotification") != nil &&
         notification_doc.at("//em:ExamManagementEventNotification").first_element_child != nil )

      event_type = notification_doc.xpath('//em:ExamManagementEventNotification')
                                   .search('//em:NarrativeClarificationResponseEvent')

      if event_type.present?
        tag_name = event_type.first.name
        if TYPES.include?(tag_name)
          content_type = tag_name
        else
          raise Exception, "Invalid Notification Type"
        end
      end

      content_type
    end
  end

end
