module RequestObjectHelper
  def addClarificationRequestEventToRequestObject(clarification_event_notification_doc, er_uuid)
    requestObject = getRequestObject(er_uuid)
    xml = requestObject.xml
    request_object_doc = XmlHelper.convertToDocument(xml)
    request_scope_events_doc = XmlHelper.getDoc(request_object_doc, "RequestScopeEvents")
    clarificationRequestEventDoc = XmlHelper.getDoc(clarification_event_notification_doc.document.root, "ClarificationRequestEvent")
    request_scope_events_doc << clarificationRequestEventDoc
    examSchedulingRequestDoc = XmlHelper.getDoc(request_object_doc, "ExamSchedulingRequest")

    saveRequestObject(examSchedulingRequestDoc['eventUuid'], er_uuid, request_object_doc.to_xml)
  end

  def add_clarification_response_event_to_request_object(clarification_response_event, claimId)
    requestObject = getRequestObject(claimId)
    xml = requestObject.xml
    request_object_doc = XmlHelper.convertToDocument(xml)
    request_scope_events_doc = XmlHelper.getDoc(request_object_doc, "RequestScopeEvents")
    request_scope_events_doc << clarification_response_event

    saveRequestObject(clarification_response_event['eventUuid'], claimId, request_object_doc.to_xml)
  end

  def handleExamSchedulingRequestCancellationEvent(examSchedulingRequestCancellationEvent, examRequest, requestObject)
    xml = requestObject.xml
    request_object_doc = XmlHelper.convertToDocument(xml)
    request_scope_events_doc = XmlHelper.getDoc(request_object_doc, "RequestScopeEvents")
    request_scope_events_doc  << examSchedulingRequestCancellationEvent

    saveRequestObject(examSchedulingRequestCancellationEvent['eventUuid'], examRequest.claim_id, request_object_doc.to_xml)
  end

  def getRequestObject(er_uuid)
    RequestObject.all.order('created_at desc').find_by_exam_request_uuid(er_uuid)
  end

  def getRequestObjectByEventId(eventId)
    RequestObject.all.order('created_at desc').find_by_event_id eventId
  end

  def saveRequestObject(eventId, er_uuid, xml)
    reqObject = RequestObject.all.order('created_at desc').find_by_exam_request_uuid er_uuid
    if reqObject.present?
      reqObject.update(active: false)
      reqObject.save
    end
    reqObject = RequestObject.create(request_type: "ClarificationRequestEvent_Notification",
                                     event_id: eventId,
                                     exam_request_uuid: er_uuid, active: true, xml: xml)
  end
end
