module ReferralNotificationMailerHelper

  def medical_record_ready_text
    if @medical_records_ready
      if 'no' == @medical_records_ready.downcase
        "1) NO, all medical records for the most recent appointment have not been uploaded."
      else
        "1) YES, all medical records for the most recent appointment have been uploaded."
      end
    end
  end

	def referral_complete_status
    if @referral_complete_status
      case @referral_complete_status.downcase
      when 'yes'
        "2) Yes, the referral is complete."
      when 'no_completed'
        "2) NO, future appointments are expected."
      when 'no_reason'
        "2) NO, our practice was unable to provide the referred service for the following reason: #{@referral.referral_reason.title}"
      else
        " "
      end
    end
  end

end
