module NtmHelper

  # Humanize a datetime object
  def  pretty_date(a_datetime)
    a_datetime.strftime(TIMESTAMP_FORMAT)
  end 

  # convert the pathname into something usable in an HREF
  def convert_to_clickable_route(a_pathname)
    if NTM_S3_ENABLED
      route = "http://amazon.com"  # TODO: flesh out the S3 access
    else
      route = a_pathname.relative_path_from(Rails.root+'public').to_s
    end
    return route
  end

  # NOTE: This junk was stolen from the "summary" gem and updated here

  # Checks the need of "summarize" the string. When it is needed, the string is splitted.
  # Then the last dot is removed and the terminator is pushed into the resultant string.
  def summary(text, size: 120, terminator: '...')
    @size, @terminator = size, terminator
    @text = (text.nil? || text.empty?) ? ' ' : text.gsub("\n", ' ')

    return pure unless summarizable?

    pure[0...string_limit].sub(/\.$/,'') + @terminator
  end

  protected
  # It cleans up the text removing the html tags, break lines and white spaces
  def pure
    @pure ||= purify @text
  end

  # Cleans up any string removing the html tags, break lines and white spaces.
  def purify(string)
    string.gsub(/(^\s+)|<(.|\n)+?>|(\t|\n|\r)+/,'').sub(/\s+/,' ')
  end

  # Calculates the size limit to summarize the string.
  def string_limit
    @string_limit ||= pure[0..(@size - backspace)].rindex(' ')
  end

  # Verifies if the string can be summarized.
  def summarizable?
    pure.size > @size and pure =~ /\s/ and string_limit >= backspace
  end

  # Measures the space needed by the terminator.
  # Let's say you want a string with 50 chars, and your terminator is a '...'.
  # That means your string can only have 47 chars + 3 chars from your terminator.
  def backspace
    @backspace ||= purify(@terminator).size
  end

end # module NtmHelper