module ExamRequestStateHelper

  IN_PROGRESS = 'IN_PROGRESS'
  PENDING_CANCELLATION = 'PENDING_CANCELLATION'
  CANCELED = 'CANCELED'
  COMPLETED = 'COMPLETED'

  def isExamRequestPendingCancellation(examRequestStateId)
    examRequestState = ExamRequestState.find_by_id(examRequestStateId)
    return compare(examRequestState, PENDING_CANCELLATION)
  end

  def isExamRequestCancelled(examRequestStateId)
    examRequestState = ExamRequestState.find_by_id(examRequestStateId)
    return compare(examRequestState, CANCELED)
  end

  def getCancelledExamRequestStateId()
    examRequestState = ExamRequestState.find_by_code(CANCELED)
    if (examRequestState == nil)
      raise Exception, 'Missing Canceled ExamRequestState'
    end
    return examRequestState.id
  end

  private

  def compare(examRequestState, stateCode)
    if (examRequestState != nil && examRequestState.code == stateCode)
      return true
    end
    return false
  end
end
