module DashboardsHelper

  def get_exam_requester examination
    er = ExamRequest.find(examination.exam_request_id)
    er.exam_requester rescue nil
  end

  def iterate_through_schedules(app)
    app.examination_schedules.inject("") { |str, app|
      str + exam_time_format(app.exam_date_time) + "</br>"
    }.html_safe
  end

  def iterate_through_exams(app)
    app.examination_ids.inject(""){ |str, id|
      str + link_to('Exam', edit_examination_path(id)) + "</br>"
    }.html_safe
  end

	def exam_time_format(input_date)
    cui_date_format(input_date, '%m-%d-%Y %H:%M')
  end

  def full_date_format(input_date)
    cui_date_format(input_date, '%m-%d-%Y %H:%M:%S %z')
  end

  def cui_date_format(input_date, format = '%m-%d-%Y')

    begin

      if input_date.kind_of?(DateTime) || input_date.kind_of?(Date) || input_date.kind_of?(Time)
        input_date.strftime(format)

      elsif input_date.kind_of?(String) && input_date != ''
        input_date.to_date.strftime(format)
      else
        ''
      end

    rescue ArgumentError
      ''
    end
  end

  def requested_site_name alert
    alert.site.present? ? alert.site.name : "Site not specified"
  end

  def requester_name alert
    User.find(alert.requested_by.to_i).name
  end

  def days_in_state(exam)
    if exam.examination_state_start_date.present?
      (DateTime.current.to_date - exam.examination_state_start_date.to_date).to_i
    else
      nil
    end
  end

  def request_link alert
    case alert.notification_type
    when Alert::REQUEST_SITE_TYPE
      site_request_site_user_path(site_id: alert.site, id: alert.requested_by.to_i)
    when Alert::REQUEST_CUI_TYPE
      access_request_user_path(id: alert.requested_by.to_i)
    else
      "#"
    end
  end

  def process_exam(exam)

    @date_created = exam_time_format(exam.created_at)

    claim = Claim.find_by_id(exam.claim_id)
    @vet_name = claim.patient_name
    @file_number = claim.file_number

    @exam_state = ExaminationState.find_by_id(exam.examination_state_id)

    if @exam_state.code == ExaminationStateHelper::CANCELLED
      @exam_state_name = 'Pending Cancellation'
    else
      @exam_state_name = @exam_state.name
    end

    if @exam_state.code == ExaminationStateHelper::PENDING
      @contentions = get_contention_names_with_cancelled(exam)
    else
      @contentions = get_contention_names(exam)
    end

    @days_in_state = days_in_state(exam)
    @exam_site = (Site.find_by_id(exam.site_id)).try(:name)
    @exam_date = exam_time_format(exam.examination_schedules.active_date_time)
    @exam_request_date = exam_time_format(exam.parent.request_date)

    if @exam_state.code == ExaminationStateHelper::READY_TO_BE_SCHEDULED

      exam_requester = get_exam_requester(exam)
      @requester_organization = exam_requester.organization.titleize rescue 'Not Supplied'
      @requester_name = exam_requester.full_name rescue 'Not Supplied'
    end

    if exam.clinician.to_s.length > 0
      @clinician_name = (User.find_by_id(exam.clinician)).name
    else
      @clinician_name = 'Not yet assigned'
    end
  end

  def process_exam_request(exam)

    @date_created = exam_time_format(exam.created_at)

    claim = Claim.find_by_id(exam.claim_id)
    @vet_name = claim.patient_name
    @file_number = claim.file_number

    @exam_state = ExamRequestState.find_by_id(exam['exam_request_state_id'])
    @exam_site = (Site.find_by_id(exam.site_id)).try(:name)

    exam_requester = ExamRequester.find(exam['exam_requester_id'])
    @requester_organization = exam_requester.organization.titleize rescue 'Not Supplied'
    @requester_name = exam_requester.full_name rescue 'Not Supplied'
  end

end
