module ContentionResultsPackageHelper
  class << self

    def build_contention_package contention_id
        con = Contention.find(contention_id)
        path = Rails.root.join("app/xml/templates/result_package_available_event.xml")
        @doc = Nokogiri::XML(File.read(path.to_s))

        @doc.at_xpath('//em:ResultPackageAvailableEvent').attribute('eventUuid').value = "#{SecureRandom.hex(4)}-#{SecureRandom.hex(2)}-#{SecureRandom.hex(2)}-#{SecureRandom.hex(2)}-#{SecureRandom.hex(6)}"
        @doc.at_xpath('//em:ResultPackageAvailableEvent').attribute('eventDtg').value = DateTime.now.strftime("%Y-%m-%dT%H:%M:%SZ")
        @doc.at_xpath('//em:ResultPackageAvailableEvent').attribute('examRelatedContentionUuid').value = con.exam_related_contention_id

        con.document_reference_ids.each do |doc_ref|
          add_new_reference_section
          @doc.xpath('//em:documentReferenceId').last.content = doc_ref.efolder_identifier
        end
      
        @doc.to_xml
        
      end

    private

    def add_new_reference_section
      dr_id_node = @doc.xpath('//em:documentReferenceId').try(:last)
      if dr_id_node.present?
        dr_id_node.add_next_sibling("<em:documentReferenceId></em:documentReferenceId>")
      else
        es = @doc.at_xpath('//em:EventSource')
        es.add_next_sibling('<em:documentReferenceId></em:documentReferenceId>')
      end
    end

  end
end