module ContentionObjectHelper
  def addOrUpdateContentionObject(exam_related_contention, examSchedulingRequestCreatedEventEntry)
    document = Nokogiri::XML('<?xml version="1.0" encoding="UTF-8" ?>')

    document << exam_related_contention

    addContentionScopeEvents(document, exam_related_contention, examSchedulingRequestCreatedEventEntry)

  end

  def addContentionScopeEvents(document, contention, examSchedulingRequestCreatedEventEntry)
    contentionScopeEventsTag = XmlHelper.createTag(document, "ContentionScopeEvents")

    resultPackageAvailableEventTag = XmlHelper.createTag(document, "ResultPackageAvailableEvent")

    resultPackageAvailableEventTag.set_attribute("eventUuid", examSchedulingRequestCreatedEventEntry.attributes["eventUuid"].value)
    resultPackageAvailableEventTag.set_attribute("eventDtg", examSchedulingRequestCreatedEventEntry.attributes["eventDtg"].value)
    resultPackageAvailableEventTag.set_attribute("modelVersion", examSchedulingRequestCreatedEventEntry.attributes["modelVersion"].value)
    resultPackageAvailableEventTag.set_attribute("examRelatedContentionUuid", contention["examRelatedContentionUuid"])

    eventSourceEntry = XmlHelper.getDoc(examSchedulingRequestCreatedEventEntry, 'EventSource')

    resultPackageAvailableEventTag << eventSourceEntry.clone
    documentReferenceTag = XmlHelper.createTag(document, "documentReference")

    #FIX ME: Need to get the right value
    documentReferenceTag.content = "24b3309b-5d5a-4ea6-b335-5248b0c4e244"

    #Add documentReferenceTag to resultPackageAvailableEventTag
    resultPackageAvailableEventTag << documentReferenceTag

    # Add resultPackageAvailableEventTag to contentionScopeEventsTag
    contentionScopeEventsTag << resultPackageAvailableEventTag

    #Add contentionScopeEventsTag to the main document
    document.root << contentionScopeEventsTag

    #Save the contention object
    save(contention["examRelatedContentionUuid"], document.to_xml)


    #examRelatedContentionUuid = contention["examRelatedContentionUuid"]
    #contentionObject = ContentionObject.all.order('created_at desc').find_by_exam_related_contention_id examRelatedContentionUuid
    #if contentionObject.present?
    #  contentionObject.update(active: false)
    #  contentionObject.save
    #end
    #ContentionObject.create(exam_related_contention_id: contention["examRelatedContentionUuid"], xml: document.to_xml, active: true)
  end

  def handleContentionCancellationRequestedEvent(notificationDoc, contention)
    contentionCancellationRequestedEvent = XmlHelper.getDoc(notificationDoc, "ContentionCancellationRequestedEvent")
    contentionObject = getContentionObject(contention.exam_related_contention_id)

    xml = contentionObject.xml
    contentionDoc = XmlHelper.convertToDocument(xml)
    contentionScopeEventsDoc = XmlHelper.getDoc(contentionDoc, "ContentionScopeEvents")

    contentionScopeEventsDoc << contentionCancellationRequestedEvent

    save(contention.exam_related_contention_id, contentionDoc.to_xml)
  end

  def handleContentionCancelledEvent(contentionCanceledEventDoc, contention)
    contentionObject = getContentionObject(contention.exam_related_contention_id)
    xml = contentionObject.xml
    contentionDoc = XmlHelper.convertToDocument(xml)

    contentionScopeEventsDoc = XmlHelper.getDoc(contentionDoc, "ContentionScopeEvents")

    contentionScopeEventsDoc << contentionCanceledEventDoc

    save(contention.exam_related_contention_id, contentionDoc.to_xml)
  end

  def getContentionObject(examRelatedContentionUuid)
    return ContentionObject.all.order('created_at desc').find_by_exam_related_contention_id examRelatedContentionUuid
  end

  private

  def save(examRelatedContentionUuid, xml)
    contentionObject = ContentionObject.all.order('created_at desc').find_by_exam_related_contention_id examRelatedContentionUuid
    if contentionObject.present?
      contentionObject.update(active: false)
      contentionObject.save
    end
    ContentionObject.create(exam_related_contention_id: examRelatedContentionUuid, xml: xml, active: true)
  end
end
