module ContentionHelper
  include ContentionObjectHelper

  def render_haml(haml, locals = {})
    Haml::Engine.new(haml.strip_heredoc, format: :html5).render(self, locals)
  end

  def generate_associated_contentions(contentions)
    contentions_rows = []

    contentions.each do |contention|

      examinations_count = 0
      exam_state = 'No Exams'

      contention.dbq_informations.each_with_index do |dbq_info, dbq_index|

        row = {}
        row[:contention_description] = contention.contention_details.first.description
        row[:contention_identifier] = contention.identifier
        row[:contention_id] = contention.id
        row[:dbq_id] = dbq_info.id
        row[:dbq_title] = dbq_info.title

        if dbq_index == 0

          row[:row_span] = contention.dbq_informations.count
          examinations_count = contention.examinations.count

          if examinations_count > 0
            exam_state = contention.examinations.order('examination_state_id asc').first.examination_state.name
          end

          row[:show_detail_link] = contention.contention_details.present?
          row[:show_cancelled_link] = contention.is_contention_cancelled == true

          if contention.is_contention_cancelled

            row[:reason_for_cancellation] = contention.reason_for_cancellation
            row[:cancellation_details] = contention.cancellation_details
          end
        end

        row[:examinations_count] = examinations_count
        row[:examinations_state] = exam_state
        contentions_rows << row
      end
    end

    return contentions_rows
  end

  def generate_associated_dbq_array(contention_id)

    dbqs = DbqInformation.where(:contentions_dbq_informations.contention_id => contention_id).order(title: :asc)
    dbq_array = []

    dbqs.each do |dbq|
      dbq_array << [dbq.title, dbq.id]
    end

    return dbq_array
  end

  def generate_not_associated_dbq_array(contention_id)

    # select all DBQs that are not already associated with this contention
    dbqs = DbqInformation.where('id NOT IN (?)', ContentionsDbqInformation.select(:dbq_information_id).where(contention_id: contention_id)).order(title: :asc)
    dbq_array = []

    dbqs.each do |dbq|
      dbq_array << [dbq.title, dbq.id]
    end

    return dbq_array
  end

  def the_comma_separated_list_of_associated_dbqs_by_title_for( the_contention_to_use )
    the_dbq_title_string = ''
    the_contention_to_use.dbq_informations.each do |the_dbq_info|
      the_dbq_title_string += "#{the_dbq_info.title},"
      the_dbq_title_string = the_dbq_title_string.chomp(',')
    end
    the_dbq_title_string
  end

  def the_comma_separated_list_of_associated_dbqs_by_identifier_for( the_contention_to_use )
    the_dbq_identifier_string = ''
    the_contention_to_use.dbq_informations.each do |the_dbq_info|
      the_dbq_identifier_string += "#{the_dbq_info.identifier},"
      the_dbq_identifier_string = the_dbq_identifier_string.chomp(',')
    end
    the_dbq_identifier_string
  end

  def the_name_and_associated_dbq_titles_string_for( the_contention_to_use )
    "#{the_contention_to_use.contention_details[0].name}-#{the_comma_separated_list_of_associated_dbqs_by_title_for(the_contention_to_use)}"
  end

  def processCancellationRequest(notificationDoc)
   ActiveRecord::Base.transaction do
    contentionCancellationRequestedEvent = XmlHelper.getDoc(notificationDoc, "ContentionCancellationRequestedEvent")

    examRelatedContentionId = contentionCancellationRequestedEvent["examRelatedContentionUuid"]

    contentionFromDb = Contention.find_by_exam_related_contention_id(examRelatedContentionId)

    cancelContention(contentionFromDb, examRelatedContentionId, notificationDoc)

    cancelContentionExaminations(contentionFromDb)

    updateContentionObject(notificationDoc, contentionFromDb)

    sendContentionCancelledEvent(contentionFromDb, contentionCancellationRequestedEvent['eventUuid'])
   end
  end

  def sendContentionCancelledEvent(contention, previousEventId)
    exam_request = ExamRequest.find_by_claim_id(contention.claim_id)
    contentionCancelledEventNotification = ContentionCancelledEventNotification.new
    eventId = contentionCancelledEventNotification.build_notification(contention, exam_request.site_id, previousEventId)
    VlerDASJob.sendNotification(contentionCancelledEventNotification, eventId, contention.claim_id, "Contention Cancelled Event Notification")
  end

  def cancelContention(contention, examRelatedContentionId, notificationDoc)
    if (contention == nil)
      raise Exception, "Invalid Exam Related Contention Id ::: " + examRelatedContentionId
    end

    #Cancel Contention
    contention.is_contention_cancelled = true

    reasonForCancellation = XmlHelper.getDoc(notificationDoc, "ReasonForCancellation")
    cancellationDetails = XmlHelper.getDoc(notificationDoc, "Details")

    if reasonForCancellation != nil && reasonForCancellation.text != nil && reasonForCancellation.text != ''
      contention.reason_for_cancellation = reasonForCancellation.text
    else
      raise Exception, "Missing Reason for Cancellation from the ContentionCancellationRequest"
    end

    if cancellationDetails != nil && cancellationDetails.text != nil && cancellationDetails.text != ''
      contention.cancellation_details = cancellationDetails.text
    else
      raise Exception, "Missing Details from the ContentionCancellationRequest"
    end
    contention.save

    #create ExamHistory entry
    examRequest = ExamRequest.find_by_claim_id(contention.claim_id)
    notes = contention.contention_details[0].name + " contention has been cancelled"
    @@exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
    @@exam_request_history.save
  end

  def cancelContentionExaminations(contention)
    #update the examination_state_id for all the contentions to PENDING_CANCELLATION, so that Scheduler user can Cancel the examination(s)
    if contention != nil && contention.examinations != nil && contention.examinations.count > 0
      contention.examinations.each do |examination|
        examinationContentions = examination.contentions
        cancelExam = true
        if (examinationContentions != nil && examinationContentions.count > 0)
          examinationContentions.each do |examContention|
            if (!examContention.is_contention_cancelled)
              cancelExam = false
            end
          end
        end

        #create ExaminationHistory
        notes = contention.contention_details[0].name + " has been cancelled"
        @@examination_history = ExaminationHistory.new(examination_id: examination.id, notes: notes)
        @@examination_history.save

        if (cancelExam)
          examStateCancelled = ExaminationState.find_by_code("CANCELLED")
          examination.examination_state_id = examStateCancelled.id
          examination.save

          examRequest = ExamRequest.find_by_id(examination.exam_request_id)
          notes = "Examination has been placed in Pending Cancellation state as a result of " + contention.contention_details[0].name + " contention being cancelled"
          @exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
          @exam_request_history.save
        end
      end
    end
  end

  def updateContentionObject(notificationDoc, contention)
    handleContentionCancellationRequestedEvent(notificationDoc, contention)
  end

  def appendContentionNames(contentions)
    contentionStr = ""
    contentions.each_with_index do |contention, index|
      separator = ""
      if index > 0 && index == contentions.count-1
        separator = " and "
      elsif index > 0
        separator = ", "
      else
        separator = " "
      end
      contentionStr = contentionStr + separator + contention.contention_details[0].name
    end
    return contentionStr
  end
end
