module ClarificationHelper
  include RequestObjectHelper

  def process_clarification_response_event(notification_doc)
   ActiveRecord::Base.transaction do
    clarification_response_event = XmlHelper.getDoc(notification_doc, "clarification_response_event")

    if (valid_clarification_response_event(clarification_response_event))
      previous_event_id = clarification_response_event['previousEventUuid']
      clarificationDetailRecord = ClarificationDetail.where("event_id = ? and clarification_type='1'", previous_event_id )

      if (clarificationDetailRecord.count == 0)
        raise Exception, "Invalid previous_event_id"
      end

      clarified_contentions_doc = XmlHelper.getDoc(clarification_response_event, "clarified_contentions")
      clarified_contentions = XmlHelper.getAll(clarified_contentions_doc, "ClarifiedContention")

      if (clarified_contentions.nil? || clarified_contentions.count == 0)
        raise Exception, "Invalid Clarification Response"
      end

      claimId = ""
      clarified_contentions.each do |clarified_contention_doc|
        examRelatedContentionId = clarified_contention_doc['examRelatedContentionUuid']
        contention = Contention.find_by_exam_related_contention_id(examRelatedContentionId)
        if contention.nil?
          raise Exception, "Invalid examRelatedContentionId"
        end

        claimId = contention.claim_id
        clarification_text = XmlHelper.getDoc(clarified_contention_doc, "ClarificationText").text

        clarificationTypeResponse = ClarificationType.find_by_code("RESPONSE")
        clarificationDetail = ClarificationDetail.create(contention_id: contention.id,
                                                         event_id: previous_event_id,
                                                         text: clarification_text,
                                                         clarification_type: clarificationTypeResponse.id)
        clarificationDetail.save
      end
      ExamRequestHistory.new(exam_request_id: previous_event_id,
                             notes: clarification_text,
                             event: "Clarification Response")

      ExamRequest.find_by_exam_request_uuid(previous_event_id)
                 .exam_request_state.update_attributes(name: "Clarification Received", code: "Clarification_Received")

      addclarification_response_eventToRequestObject(clarification_response_event, claimId)
    else
      raise Exception, "Invalid ClarificationResponse"
    end
   end
  end

  def process_narrative_clarification_response_event(notification_doc)
    ActiveRecord::Base.transaction do
    clarification_response = XmlHelper.getDoc(notification_doc, "NarrativeClarificationResponseEvent")

    if (valid_clarification_response_event(clarification_response))
      clarification_text = clarification_response.at('//em:ContentionClarificationTextEntries','//em:ContentionClarificationText').elements
      exam_request_uuid = clarification_response['examSchedulingRequestUuid']

      count = 0
      clarification_array = []
      clarification_text.each do |node|

        node.children.each do |attr_name, attr_value|

          if attr_name.blank? && attr_value.blank?
            next
          else
            nar_ent = attr_name.text
            con_uuid = node['contentionUuid']
            clarification_array << { contention_uuid: con_uuid, narative_entry: nar_ent }
          end
        end
      end

      if clarification_array.present?
        clarification_array.each do |element|
          clarification_detail_record = ClarificationDetail.where("event_id = ? and clarification_type='1' and clarified=false", element[:contention_uuid]).first

          if clarification_detail_record.nil?
            raise Exception, "Invalid contention uuid and Invalid Clarification Response"
          end

          contention = Contention.find_by_exam_related_contention_id(element[:contention_uuid])

          if contention.nil?
            raise Exception, "Invalid exam_related_contention_id"
          end

          clarificationTypeResponse = ClarificationType.find_by_code("RESPONSE")
          clarificationDetail = ClarificationDetail.create(contention_id: contention.id,
                                                           event_id: element[:contention_uuid],
                                                           text: element[:narative_entry],
                                                           clarification_type: clarificationTypeResponse.id,
                                                           clarified: true)
          clarificationDetail.save
          clarification_detail_record.update_attribute(:clarified, true)
          exam_request_id = contention.exam_request_id

          ExamRequestHistory.create(exam_request_id: exam_request_id,
                                 notes: element[:narative_entry],
                                 event: "Clarification Response")

          exam_request = ExamRequest.find(exam_request_id)

          exam_request_contention_ids = []
          exam_request.contentions.each {|con| exam_request_contention_ids << con.id }
          all_clarified = ClarificationDetail.where(contention_id: exam_request_contention_ids)
                                             .collect { |cd| cd.clarified }
                                             .all?(true)
          if all_clarified
            exam_request.exam_request_state = ExamRequestState.find_by_code('CLARIFICATION_RECEIVED')
            exam_request.save
          end

          #add_clarification_response_event_to_request_object(clarification_response_event, claimId)
        end
      end


    else
      raise Exception, "Invalid ClarificationResponse"
    end
   end
  end

  def valid_clarification_response_event(clarification_response_event)
    # requestObjectDoc = XmlHelper.convertToDocument(clarification_response_event.xml)
    # examSchedulingRequest = XmlHelper.getDoc(clarification_response_event, "ExamSchedulingRequest")
    # examSchedulingRequestId = examSchedulingRequest['examSchedulingRequestUuid']
    # if (examSchedulingRequestId != examSchedulingRequestIdFromCancellationRequest)
    #   raise Exception, "Invalid examSchedulingRequestUuid. Unable to locate the ExamRequest record"
    # end

    return true
  end

  def build_and_send_clarification_request_event(user, examRequestIdentifier, selectedContentionIds, clarificationRequest)
    exam_request = ExamRequest.find_by_identifier(examRequestIdentifier)

    clarificationRequestEvent = ClarificationRequestEvent.new
    eventId = clarificationRequestEvent.build_notification(exam_request.exam_request_uuid, exam_request.site_id, user, clarificationRequest)
    VlerDASJob.sendNotification(clarificationRequestEvent, eventId, exam_request.exam_request_uuid, "Clarification Request Event Notification")

    addClarificationRequestEventToRequestObject(clarificationRequestEvent, exam_request.exam_request_uuid)
    #create ExamHistory entry
    addExamRequestHistory(selectedContentionIds, exam_request)

    return eventId
  end

  private

  def addExamRequestHistory(selectedContentionIds, examRequest)
    notes = current_user.first_name + " " + current_user.last_name + " requested clarification "
    selectedContentionIds.each_with_index do |contention_id, index|
      contention = Contention.find_by_id(contention_id)
      separator = ""
      if index > 0 && index == selectedContentionIds.length-1
        separator = " and "
      elsif index > 0
        separator = ", "
      else
        separator = " "
      end
      notes = notes + separator + contention.clarification_details.last.text
    end
    notes = notes + "the exam request" if selectedContentionIds.empty?
    @exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id,
                                                   notes: notes,
                                                   event: "Clarification Needed")
    @exam_request_history.save
  end
end
