module AppointmentObjectHelper
  def updateAppointmentObjectWithRescheduleEvent(notificationDoc, appointmentObjectFromDb)
    appointmentRescheduleRequestEvent = XmlHelper.getDoc(notificationDoc, "RescheduleRequestEvent")

    xml = appointmentObjectFromDb.xml

    appointmentDoc = XmlHelper.convertToDocument(xml)

    examAppointmentStatusEventsDoc = XmlHelper.getDoc(appointmentDoc, "ExamAppointmentStatusEvents")

    examAppointmentStatusEventsDoc << appointmentRescheduleRequestEvent

    saveAppointmentObject(appointmentObjectFromDb, appointmentDoc.to_xml)
  end

  def handleAppointmentRescheduleEvent(apptScheduledEvent, examAppointmentUuid)
    appt_object = AppointmentObject.all.order('created_at desc').find_by_exam_appointment_uuid examAppointmentUuid
    appointmentDoc = XmlHelper.convertToDocument(appt_object.xml)
    examAppointmentStatusEventsDoc = XmlHelper.getDoc(appointmentDoc, "ExamAppointmentStatusEvents")
    examAppointmentStatusEventsDoc << apptScheduledEvent

    saveAppointmentObject(appt_object, appointmentDoc.to_xml)
    
  end

  def handleAppointmentScheduledEvent(apptScheduledEvent, examination, examAppointmentUuid, contentions)
    path = File.join(Rails.root.to_s, 'app', 'xml', 'templates', 'appointment_object.xml')
    document = Nokogiri::XML(File.open(path))
    appointmentScheduledEventFromTemplate = XmlHelper.getDoc(document, 'AppointmentScheduledEvent')
    appointmentScheduledEventFromTemplate.remove
    examAppointmentStatusEvents = XmlHelper.getDoc(document, "ExamAppointmentStatusEvents")
    examAppointmentStatusEvents << apptScheduledEvent

    if (contentions != nil && contentions.count > 0)
      examRelatedContentionUuidsDoc = XmlHelper.getDoc(document, "ExamRelatedContentionUuids")
      contentions.each do |contention|
        uuidValueTag = XmlHelper.createTag(document, "UuidValue")
        uuidValueTag.content = contention.exam_related_contention_id

        examRelatedContentionUuidsDoc << uuidValueTag
      end

       examAppointmentDoc = XmlHelper.getDoc(document, "ExamAppointment")
       examAppointmentDoc['examAppointmentUuid'] = examAppointmentUuid
       examAppointmentDoc << examRelatedContentionUuidsDoc
    else
      raise Exception, "Contention cannot be nil while constructing an AppointmentObject"
    end

    appt_object = AppointmentObject.all.order('created_at desc').find_by_exam_appointment_uuid examAppointmentUuid
    if appt_object.present?
      appt_object.update(active: false)
      appt_object.save
    end
    appt_object = AppointmentObject.create(examination_identifier: examination.identifier, exam_appointment_uuid: examAppointmentUuid, active: true, xml: document.to_xml)
  end

  def handleAppointmentCancelRequestEvent(notificationDoc, appointmentObjectFromDb)
    appointmentCancelRequestEvent = XmlHelper.getDoc(notificationDoc, "AppointmentCancelRequestEvent")

    xml = appointmentObjectFromDb.xml

    appointmentDoc = XmlHelper.convertToDocument(xml)

    examAppointmentStatusEventsDoc = XmlHelper.getDoc(appointmentDoc, "ExamAppointmentStatusEvents")

    examAppointmentStatusEventsDoc << appointmentCancelRequestEvent

    saveAppointmentObject(appointmentObjectFromDb, appointmentDoc.to_xml)
  end

  def handleAppointmentCancelledEvent(notificationDoc, appointmentObjectFromDb)
    appointmentCancelledEvent = XmlHelper.getDoc(notificationDoc, "AppointmentCanceledEvent")

    xml = appointmentObjectFromDb.xml

    appointmentDoc = XmlHelper.convertToDocument(xml)
    examAppointmentStatusEventsDoc = XmlHelper.getDoc(appointmentDoc, "ExamAppointmentStatusEvents")

    examAppointmentStatusEventsDoc << appointmentCancelledEvent

    saveAppointmentObject(appointmentObjectFromDb, appointmentDoc.to_xml)
  end

  def getAppointmentObject(examAppointmentUuid)
    return AppointmentObject.all.order('created_at desc').find_by_exam_appointment_uuid examAppointmentUuid
  end

  def saveAppointmentObject(previousAppointmentObject, xml)
    appointmentObject = AppointmentObject.all.order('created_at desc').find_by_exam_appointment_uuid previousAppointmentObject.exam_appointment_uuid
    if appointmentObject.present?
      appointmentObject.update(active: false)
      appointmentObject.save
    end
    AppointmentObject.create(examination_identifier: previousAppointmentObject.examination_identifier, exam_appointment_uuid: previousAppointmentObject.exam_appointment_uuid, active: true, xml: xml)
  end
end
