class Vista::VeteransController < ApplicationController


 
  # Method triggered by the a Search submit from the user
  def search
    if params[:commit].present?
      if params[:commit] == "Search"
        if params[:last_name].blank? && params[:first_name].blank? && params[:veteran_birth_date].blank?
          flash.now[:alert] = "Please fill in at least one field in order to search"
        elsif cookie = authentication_request
          results = search_request(params[:last_name], params[:first_name], params[:veteran_birth_date], cookie)
          if results.code == 200
            @veterans = eval(results.body)[:data][:items]
            @veterans.count < 1 ? flash.now[:alert] = "No matching Veterans were found." : flash.now[:notice] = "The following results for Veterans were found:" 
          else
            flash.now[:alert] = eval(results.body)[:message]            
          end
        else
          flash.now[:alert] = "Unable to obtain authentication for request " 
        end
      end
    end
  end
  
  
  def selected
    if params.try(:[], :commit) == "Submit"
      @veterans = []
      params[:select].each do |s|
        vet = {}
        fields = s[0].split(", ")
        vet[:fullName] = fields[0]
        vet[:age] = fields[1]
        vet[:genderName] = fields[2]
        vet[:birthDate] = fields[3]
        vet[:ssn] = fields[4]
        vet[:city] = fields[5]
        vet[:state] = fields[6]
        vet[:zip] = fields[7]
        @veterans << vet
        flash.now[:notice] = "You have selected the following Veteran(s) "
      end
    elsif params.try(:[], :commit) == "Add"
      @veterans = []
      vet = {}
      vet[:fullName] = params[:first_name] + " " + params[:last_name]
      vet[:birthDate] = params[:veteran_birth_date]
      vet[:city] = params[:city]
      vet[:state] = params[:state]
      vet[:zip] = params[:zip]       
      @veterans << vet
      flash.now[:notice] = "You have successfully added the following Veteran "
    end
  end
  
  
  def add
    if params[:commit].present? 
      proceed = true
      params[:first_name].blank? ? (@fname_blank = true; proceed=false) : false
      params[:last_name].blank? ? (@lname_blank = true; proceed=false) : false
      params[:veteran_birth_date].blank? ? (@veteran_birth_date_blank = true; proceed=false) : false
      params[:email].blank? ? (@email_blank = true; proceed=false) : false
      params[:phone_number].blank? ? (@phone_number_blank = true; proceed=false) : false
      params[:city].blank? ? (@city_blank = true; proceed=false) : false
      params[:state].blank? ? (@state_blank = true; proceed=false) : false
      params[:zip].blank? ? (@zip_blank = true; proceed=false) : false
      
      if proceed == false
        flash.now[:alert] = "Please fill in the required fields below:"
      elsif cookie = authentication_request
        response = add_veteran(params[:last_name], params[:first_name], params[:veteran_birth_date], params[:email], params[:phone_number], params[:city], params[:state], params[:zip], cookie)
        if response[:code] == 200
          redirect_to :action => :selected, :params => request.request_parameters
        else
          flash.now[:alert] = "Unable to add Veteran. Please check that all required information has been submitted."           
        end
      else
        flash.now[:alert] = "Unable to obtain authentication for request "  
      end
    end
  end



  private
  
    # Get authorization from VistA. Must be obtained to establish a session for further communication with VistA.
    def authentication_request
      url = "DNS.DNS"
      request = Faraday.new(url)
      response = request.post do |req|
        req.headers['Content-Type']   = 'application/json'
        req.headers["Cache-Control"]  = "no-cache"
        req.body                      =
        '{
          "accessCode": "pu1234",
          "verifyCode": "pu1234!!",
          "site": "9E7A"
        }'
      end
      cookie = response.headers['set-cookie']
      response.code == 200 ? cookie : false 
    end
  
  
    # Send search request to VistA.
    def search_request(lname, fname, bdate, cookie)
      url = "https://DNS.DNS
      request = Faraday.new(url)

      response = request.post do |req|
        req.headers["Content-Type"] = "application/json"
        req.headers["Cookie"]       = cookie
        body_string = '{'
        !lname.blank? ? body_string += '"name.last": "'+lname+'", ' : false
        !fname.blank? ? body_string += '"name.first": "'+fname+'", ' : false
        !bdate.blank? ? body_string += '"date.birth": "'+bdate+'", ' : false
        body_string.length > 5 ? body_string.chomp!(", ") : false
        body_string += '}'
        req.body = body_string
      end
      return response
    end  


    def add_veteran(lname, fname, bdate, email, phone_number, city, state, zip, cookie)
      url = "https://DNS.DNS
      request = Faraday.new(url)

      response = request.post do |req|
        req.headers["Content-Type"] = "application/json"
        req.headers["Cookie"]       = cookie
        body_string = '{'
        !lname.blank? ? body_string += '"name.last": "'+lname+'", ' : false
        !fname.blank? ? body_string += '"name.first": "'+fname+'", ' : false
        !bdate.blank? ? body_string += '"date.birth": "'+bdate+'", ' : false
        !email.blank? ? body_string += '"email": "'+email+'", ' : false
        !phone_number.blank? ? body_string += '"phone.number": "'+phone_number+'", ' : false
        !city.blank? ? body_string += '"city": "'+city+'", ' : false
        !state.blank? ? body_string += '"state": "'+state+'", ' : false
        !zip.blank? ? body_string += '"zip": "'+zip+'", ' : false
        body_string.length > 5 ? body_string.chomp!(", ") : false
        body_string += '}'
        req.body = body_string
      end
      response = {}
      response[:code] = 200
      return response
    end
              
end
