class Vista::LoadingClinicsController < ApplicationController

  def show
    @site_station_number = params[:site_station_number]
    @is_cpp_user = current_user.is_cpp_user?

    respond_to do |format|
      format.html { render }
      format.json {
        if site_loaded_or_invalid_station_number?
          render json: {}, status: 200
        else
          render :json => "loading", :status => 202
        end
      }
    end
  end

  private

  def site_loaded_or_invalid_station_number?
    site = Site.find_by_site_station_number(@site_station_number)
    site.nil? || site.loaded?
  end

end
