class SiteController < ApplicationController
  rescue_from ::Exception, with: :error_occurred
  skip_before_action :clear_current_site #, except: [:index]
  check_authorization
  authorize_resource

  def index
    if current_user.is_app_admin?
      @sites = Site.all.order(name: :asc)
    else
      @sites = current_user.sites
    end
    @site_role_sets = current_user.site_role_sets
    if @sites.count == 0 && !current_user.is_app_admin?
      flash.now[:alert] = "You currently do not have access to any sites"
    end
  end

  def show
    @site = Site.find params[:format]
    @site_roles = current_user.get_site_roles(@site)
    if !@site_roles
      raise "An error has occured ::: Attempting to access an unassigned site. Site ::: #{@site.name}."
    end
  end

  def new
    @site = Site.new
  end

  def create
    @site = Site.new(name: params[:name], address: params[:address], city: params[:city], state: params[:state], country: params[:country])
    if @site.valid?
      @site.save
      flash[:notice] = @site.name + " has been successfully added"
      redirect_to action: "new"
    else
      errors_string = "Please correct the following errors:<br><br/>"
      @site.errors.full_messages.each do |msg|
        errors_string += "&nbsp;&nbsp;&nbsp; - " + msg + "<br/><br/>"
      end
      errors_string = errors_string.html_safe
      flash.now[:alert] = errors_string
      render "new"
    end
  end

  def edit
  end

  def update
  end

  def destroy
  end

  def access_requests
    @site = Site.find(params[:id])
    @users = @site.get_requesting_users
  end

  private

  def error_occurred(e)
    Rails.logger.info e
    redirect_to dashboards_path
  end
end
