class SessionsController < Devise::SessionsController
  before_filter :save_cpp_status,     :only => :destroy
  after_filter  :clear_vista_session, :only => :destroy

  def clear_vista_session
    session.delete(:vista)
  end

  # Capture is_cpp_user? value in session cookie temporarily for redirect
  # when ApplicationController#after_sign_out_path_for gets called.
  def save_cpp_status
    cookies['is_cpp_user'] = current_user.is_cpp_user?
  end

end
