class ReportsController < ApplicationController
  include InsufficientExamReportGenerator
  include ExaminationsHelper
  check_authorization
  authorize_resource class: false

  #TODO: Refactor controller too many one off conditionals.

  def insufficient_exam_report

    @start_date_param = params[:start_date]
    @end_date_param = params[:end_date]

    if valid_date_string(params[:start_date]) && valid_date_string(params[:end_date])

      start_date = Date.strptime(params[:start_date], '%m/%d/%Y')
      end_date = Date.strptime(params[:end_date], '%m/%d/%Y')

      if start_date >= end_date
        flash.now[:alert] = 'The end date must be after the start date'
      else

        @contention_array = []
        columns = [:exam_date, :patient_name, :benefit_type, :special_issues, :contention_description, :previous_contention_exams, :rework_reason_list, :rework_reason_free_text_list]
        contentions = Contention.joins(:exam_request)
                          .where(exam_requests: {site_id:  site_ids})
                          .where(insufficient: true, :created_at => start_date.beginning_of_day..end_date.end_of_day)

        contentions.each do |contention|

          contention_hash = {}

          columns.each do |column|
            contention_hash[column] = contention.send(column)
          end

          @contention_array << contention_hash
        end

        if params[:column_name].present?
          @contention_array.sort_by! { |hash| hash[columns[params[:column_name].to_i]] }

          if params[:sort_direction].to_s == 'desc'
            @contention_array.reverse!
          end
        end

        flash.now[:notice] = 'The following Insufficient Exams have been retrieved for the given date range:'
      end

    else

      if params[:commit].present?
        flash.now[:alert] = 'Please provide a valid date range'
      end
    end

    respond_to do |format|

      format.html #render 'reports/insufficient_exam_report.html'
      format.csv  { send_data generate_insufficient_exam_report_csv(@contention_array), filename: "insufficient_exam_report-#{Date.today}.csv" }
      format.text { send_data generate_insufficient_exam_report(@contention_array, start_date, end_date), filename: "insufficient_exam_report-#{Date.today}.txt" }
    end
  end

  def pending_exam
    column_titles = %w( Veteran\ Name Cell\ Number E-mail Claim\ Number Request\ Date Elapsed\ Days Claim\ Type Special\ Considerations Exams\ Requested Exam Stats\ Total\ Exams\ Pending )
    column_attributes = ["first_name", "phone_number", "email", "file_number", "request_date",
                         "elapsed_days", "benefit_type", "special_issues", "exams_requested", "exam_state_name",
                         "total_number_of_exams_pending"]
    column_sort_name = column_attributes[params[:column_name].to_i] if params[:column_name].present?
    sort_direction = params[:sort_direction].downcase == "asc" ? "asc" : "desc" if params[:sort_direction].present?
    order_query = "#{column_sort_name} #{sort_direction}"
    @request_status = params[:request_status]
    @routing_location = params[:routing_location]
    @patient_name = params[:p_name]
    @elapsed_days = params[:elapsed_days]

    if !valid_date_string(params[:elapsed_days]) && params[:commit].present?
        params.delete(:elapsed_days)
        flash.now[:alert] = "Please enter a valid date for Age of Request."
        return
    end

    if params[:commit].present?
        @exam_requests = ExamRequest.where(nil)
        @exam_requests = @exam_requests.joins(:claim)
                .includes(contentions: :dbq_informations)
                .includes(:exam_requester)
                .includes(:exam_request_state)
                .includes(:examinations)

        filtering_params(params).each do |key, value|
            @exam_requests = @exam_requests.public_send(key, value) if value.present?
        end

        if @exam_requests.present? && params[:sort_direction].to_s.length <= 4
            if virtual_attributes.include?(column_sort_name)
              if params[:sort_direction] == "asc"
                  @exam_requests = @exam_requests.sort_by {|h| h.send(column_sort_name.to_sym)}
              else
                  @exam_requests = @exam_requests.sort_by {|h| h.send(column_sort_name.to_sym)}.reverse!
              end
            else
              @exam_requests = @exam_requests.order(order_query)
            end
        end
      end

      respond_to do |format|
        format.html
        format.text { send_data render_to_string(template: "reports/plain_text").gsub(/[\r\n]+/, "\r\n"),
                                                 filename: "pending_exam_report-#{Date.today}.txt" }
        format.csv { send_data ReportCsv.generate(@exam_requests, column_attributes, column_titles),
                                                  filename: "pending_exam_report-#{Date.today}.csv" }
      end
  end

  def exam_requests_by_date
    attributes = [:request_date, :patient_name, :request_status_name, :benefit_type, :special_issues, :id, :exam_request_uuid]
    col_titles = ['Request Date', 'Patient Name', 'Status', 'Claim Type', 'Special Considerations', 'Date Released' 'Request ID' ]
    column_attributes = ["request_date", "first_name", "exam_state_name", "benefit_type", "special_issues", "id", "exam_request_uuid"]
    column_sort_name = column_attributes[params[:column_name].to_i] if params[:column_name].present?
    sort_direction = params[:sort_direction].downcase == "asc" ? "asc" : "desc" if params[:sort_direction].present?
    order_query = "#{column_sort_name} #{sort_direction}"

    if valid_date_string(params[:exam_request_start_date]) && valid_date_string(params[:exam_request_end_date])
      start_date = Date.strptime(params[:exam_request_start_date], '%m/%d/%Y')
      end_date = Date.strptime(params[:exam_request_end_date], '%m/%d/%Y')
      if start_date > end_date
        flash.now[:alert] = "The end date must be after the start date"
      else
        @exam_requests = ExamRequest.where(request_date: start_date.beginning_of_day .. end_date.end_of_day)
                                    .where(site: site_ids)

        flash.now[:notice] = "The following Examination Requests have been retrieved for the given date range: #{start_date} to #{end_date}"
      end
    else
      flash.now[:alert] = "Please enter a valid date range for Examination Requests" if params[:commit].present?
    end

    if @exam_requests.present? && params[:sort_direction].to_s.length <= 4
        if virtual_attributes.include?(column_sort_name)
          if params[:sort_direction] == "asc"
              @exam_requests = @exam_requests.sort_by {|h| h.send(column_sort_name.to_sym)}
          else
              @exam_requests = @exam_requests.sort_by {|h| h.send(column_sort_name.to_sym)}.reverse!
          end
        else
          @exam_requests = @exam_requests.order(order_query)
        end
    end

    respond_to do |format|
        format.html
        format.text { send_data render_to_string(template: "reports/exam_requests_by_date_plain_text").gsub(/[\n]+/, "\r\n"),
                                                 filename: "exam_requests_by_date_report-#{Date.today}.txt" }
        format.csv { send_data ReportCsv.generate(@exam_requests, attributes, col_titles),
                                                  filename: "exam_requests_by_date_report-#{Date.today}.csv" }
    end
  end

  def exam_request_status_by_date
      @request_status_param = params[:request_status]
      @start_date_param = params[:exam_request_start_date]
      @end_date_param = params[:exam_request_end_date]

      attributes = [:request_date, :patient_name, :date_released,  :request_status_name, :vba_requesting_station, :benefit_type, :special_issues, :reroute_date, :reroute_to_site, :reroute_from_site, :date_cancelled, :cancellation_reason, :cancellation_comments]
      col_titles = ['Request Date', 'Patient Name', 'Date Released', 'Status', 'VBA Requesting Station', 'Claim Type', 'Special Considerations', 'Re-Route Date', 'Re-Route To Site', 'Re-Route From Site', 'Date Cancelled', 'Cancellation Reason', 'Cancellation Comments']
      column_attributes = ["request_date", "first_name", "date_released", "exam_state_name", "vba_requesting_station", "benefit_type", "special_issues", "reroute_date", "reroute_to_site", "reroute_from_site", "date_cancelled", "cancellation_reason", "cancellation_comments"]
      column_sort_name = column_attributes[params[:column_name].to_i] if params[:column_name].present?
      sort_direction = params[:sort_direction].downcase == "asc" ? "asc" : "desc" if params[:sort_direction].present?
      order_query = "#{column_sort_name} #{sort_direction}"

      if valid_date_string(params[:exam_request_start_date]) && valid_date_string(params[:exam_request_end_date])
          params[:request_status].present? ? @exam_req_state = ExamRequestState.find(params[:request_status]) : @exam_req_state = ExamRequestState.all
          if params[:exam_request_start_date].present? && params[:exam_request_end_date].present?
              start_date = Date.strptime(params[:exam_request_start_date], '%m/%d/%Y')
              end_date = Date.strptime(params[:exam_request_end_date], '%m/%d/%Y')
              if start_date >= end_date
                  flash.now[:alert] = "The end date must be after the start date"
              else
                  @exam_requests = ExamRequest.where(request_date: start_date.beginning_of_day .. end_date.end_of_day,
                                                     exam_request_state: @exam_req_state)
                                              .where(site: site_ids)
                  flash.now[:notice] = "The following Examination Requests have been retrieved for the given date range: #{start_date} to #{end_date}"
              end
          else
              @exam_requests = ExamRequest.where(exam_request_state: @exam_req_state)
                                          .where(site: site_ids)
              flash.now[:notice] = "The following Examination Requests were retrieved for a blank date range"
          end
      else
          if params[:commit].present?
              flash.now[:alert] = "Please enter a valid date range for Examination Requests"
          end
      end
      if @exam_requests.present? && params[:sort_direction].to_s.length <= 4
          if virtual_attributes.include?(column_sort_name)
              if params[:sort_direction] == "asc"
                  @exam_requests = @exam_requests.sort_by {|h| h.send(column_sort_name.to_sym)}
              else
                  @exam_requests = @exam_requests.sort_by {|h| h.send(column_sort_name.to_sym)}.reverse!
              end
          else
              @exam_requests = @exam_requests.order(order_query)
          end
      end
      respond_to do |format|
          format.html
          format.text { send_data render_to_string(template: "reports/exam_request_status_by_date_plain_text").gsub(/[\n]+/, "\r\n"),
                                                   filename: "exam_request_status_by_date_report-#{Date.today}.txt" }
          format.csv { send_data ReportCsv.generate(@exam_requests, attributes, col_titles),
                                                   filename: "exam_request_status_by_date_report-#{Date.today}.csv"  }
      end
  end

	private
    def virtual_attributes
      ["request_status", "routing_location", "p_name", "elapsed_days", "exams_requested",
       "exam_state_name", "total_number_of_exams_pending", "first_name", "benefit_type"]
    end

		def filtering_params(params)
			params.slice(:request_status, :routing_location, :p_name, :elapsed_days)
		end

    def site_ids
        User.site_ids(current_user)
    end

end
