class ReferralNotesController < ApplicationController
  include ApplicationHelper
  before_action :set_referral, only: [:create, :ajax_load_referral_notes]
  check_authorization
  authorize_resource

  def create
    @referral_note = @referral.referral_notes.new(referral_note_params)
    @referral_note.user = current_user.name
    respond_to do |format|
      if @referral.save
        format.html do
          flash[:notice] = 'Referral Note was successfully created.'
          redirect_to referral_path(@referral, tabpage: 'notes')
        end
        format.json { render json: @referral, status: :created }
      else
        format.html do
          flash[:alert] = @referral.errors.full_messages.join(" ")
          redirect_to referral_path(@referral, tabpage: 'notes')
        end
        format.json { render json: @referral.errors, status: :unprocessable_entity }
      end
    end
  end

  def ajax_load_referral_notes
    ret_json = []
    referral_notes = @referral.referral_notes.order('created_at DESC')

    referral_notes.each do |ref_note|
      obj = ref_note.user

      if obj.is_a?(String)
        username = obj
      elsif obj.is_a?(Fixnum)
        begin
          username = User.find(ref_note.user).name
        rescue
          username = "Invalid user id set in referral note (referral_note_id = #{ref_note.id})."
        end
      else
        username = "Invalid data. User is not a string or an id (referral_note_id = #{ref_note.id})."
      end

      created_at = ref_note.created_at
      ref_note = ref_note.as_json
      ref_note[:username] = username
      ref_note[:formatted_created_at] = formatted_datetime(created_at, current_user)
      ret_json << ref_note
    end
    render json: ret_json.as_json
  end

private
  # Use callbacks to share common setup or constraints between actions.
  def set_referral
    @referral = Referral.find(params[:referral_id])
  end

  # Never trust parameters from the scary internet, only allow the white list through.
  def referral_note_params
    params.require(:referral_note).permit(:user, :notes)
  end

end