class ProvidersController < ApplicationController
  check_authorization
  authorize_resource

  def show
    @provider = NpiRegistry.filter(npi: params[:id])
    respond_to do |format|
      unless @provider.nil?
        format.json { render json: @provider,
                           methods: [:id, :phone, :fax, :formatted_address_string, :medical_specialty_names] }
      else
        format.json { render json: {error: 'Invalid NPI value.'}, status: :unprocessable_entity }
      end
    end
  end

  def find_by_npi
    provider = NpiRegistry.filter(npi: params[:npi])
    unless provider.nil?
      render json: provider, methods: [:id, :phone, :fax, :formatted_address_string, :medical_specialty_names], status: :ok
    else
      render json: {error: 'Invalid NPI value.'}, status: :unprocessable_entity
    end
  end

end
