class PagesController < ApplicationController
  skip_before_filter :authenticate_user_and_handle_cookies, only: [:request_access, :privacy_policy]
  check_authorization
  authorize_resource class: false
  
  def help
    unless current_user.is_cpp_user?
      filename = "CUI_User_Guide.pdf"
    else
      if current_user.is_vha_cc?
        filename = "CPP_VHA_User_Guide.pdf"
      else
        filename = "CPP_CP_User_Guide.pdf"
      end
    end

    pdf_filename = File.join(Rails.root, "public/" + filename)
    send_file(pdf_filename, :filename => filename, :disposition => "inline", :type => "application/pdf")
  end

  def examiners
  end

  def schedulers
  end

  def request_access
    @user = User.find params[:user_id]
    @user.authorization_state = "pending"
    @user.save
    @app_admins = User.where("roles like ?", "%app_admin%")

    @app_admins.try(:each){|a|
      UserMailer.access_request(@user, a).deliver_now
    }

    #add alert for app_admins about this user's request for access

    Alert.create_access_request(@user)
  end

  def environment
    @vars = ENV.to_h.sort_by { |k,v| k }
  end

end
