class LandingController < ApplicationController
  skip_before_action :clear_current_site, except: [:index]
  check_authorization
  authorize_resource class: false

  def index
    if current_user
      @auth_state = current_user.authorization_state
      @user = current_user
      if @user.is_new_user?
        redirect_to landing_site_request_path
      elsif @auth_state == "authorized"
        cui_user_login
      else
        sign_out current_user
        flash.clear
        flash.now[:alert] = "You do not currently have access to the CUI system."
      end
    end
  end

  def set_site
    @user = current_user
    @my_sites = @user.sites.order(name: :asc).map{ |s| [s.name, s.id] }
    if params[:my_site_select] && params[:my_site_select][:id]
      $current_site = Site.find params[:my_site_select][:id]
      $current_site_roles = current_user.get_site_roles($current_site)
      flash[:notice] = "Your current working site has been set to: #{$current_site.name}"
      redirect_to claims_path
    end
  end

  def site_request
    if current_user
      @auth_state = current_user.authorization_state
      @user = current_user
      if @auth_state == "authorized"
        @my_sites = @user.sites.order(name: :asc).map{ |s| [s.name, s.id] }
        @all_sites = Site.all.order(name: :asc).map{ |s| [s.name, s.id] }
        @all_sites = @all_sites - @my_sites
      else
        sign_out current_user
        flash.clear
        flash.now[:alert] = "You do not currently have access to the CUI system."
      end
    end

    if params[:all_site_select] && params[:all_site_select][:id]
      requested_site = Site.find(params[:all_site_select][:id])
      requested_roles = ""
      uroles = params[:user_roles]
      uroles && uroles[:admin] ? requested_roles += " < Administrator > " :  false
      uroles && uroles[:triage] ? requested_roles += " < Triage > " :  false
      uroles && uroles[:scheduling] ? requested_roles += " < Scheduling > " :  false
      uroles && uroles[:clinician] ? requested_roles += " < Clinician > " :  false
      uroles && uroles[:super_clinician] ? requested_roles += " < Supervisory Clinician > " :  false
      uroles && uroles[:qa] ? requested_roles += " < Quality Assurance > " :  false

      requested_site.add_requesting_user(current_user, requested_roles)
      @site_admins = User.all.includes(:sites).where(:sites => {name: requested_site.name}).includes(:site_role_sets).where(:site_role_sets => {admin: "true"})
      @site_admins.try(:each){|sa|
        UserMailer.site_access_request(current_user, sa, requested_site, requested_roles).deliver_now
      }

      #new alert for site request
      Alert.create_site_request(@user, requested_site)

      flash[:notice] = "Your request for access to #{requested_site.name} has been sent."
      redirect_to landing_site_request_path
    end
  end

  private
  # Use callbacks to share common setup or constraints between actions.
  def set_dashboard
    @dashboard = Dashboard.find(params[:id])
  end

  # Never trust parameters from the scary internet, only allow the white list through.
  def dashboard_params
    params[:dashboard]
  end

  def get_clinician_other_examinations()
    ex_state_sch = ExaminationState.find_by_code(ExaminationStateHelper::SCHEDULED)
    ex_state_ip = ExaminationState.find_by_code(ExaminationStateHelper::IN_PROGRESS)
    sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {clinician: "true"})

    if sites_with_my_role.present?
      exams = sites_with_my_role.map {|n| n.examinations}.flatten.select{|ex| (ex.clinician == current_user.id and ex.examination_state_id != ex_state_sch.id and ex.examination_state_id != ex_state_ip.id)}
      return exams
    else
      return []
    end
  end

  # Get the examinations based on the provided user role and exam state.
  def get_examinations(role, exam_state)
    ex_state = ExaminationState.find_by_code(exam_state)
    #  sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {"#{role}": "true"})
    if role == "admin"
      sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {admin: "true"})
    elsif role == "triage"
      sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {triage: "true"})
    elsif role == "scheduling"
      sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {scheduling: "true"})
    elsif role == "clinician"
      sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {clinician: "true"})
    elsif role == "super_clinician"
      sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {super_clinician: "true"})
    elsif role == "qa"
      sites_with_my_role = current_user.sites.includes(:site_role_sets).where(:site_role_sets => {qa: "true"})
    end
    if sites_with_my_role.present?
      exams = sites_with_my_role.map {|n| n.examinations}.flatten.select{|ex| ex.examination_state == ex_state}
      return exams
    else
      return []
    end
  end

  def cui_user_login
    if VIA_ACTIVE_FOR_CUI && session[:vista].blank?
      redirect_to vista_path
    else
      redirect_to dashboards_path
    end
  end


end
